/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.List;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.GenericJsTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;
import org.squashtest.tm.web.internal.model.builder.TestSuiteNodeBuilder;

@Component
@Scope(value="prototype")
public class IterationNodeBuilder
extends GenericJsTreeNodeBuilder<Iteration, IterationNodeBuilder> {
    protected InternationalizationHelper internationalizationHelper;

    @Inject
    public IterationNodeBuilder(PermissionEvaluationService permissionEvaluationService, InternationalizationHelper internationalizationHelper) {
        super(permissionEvaluationService);
        this.internationalizationHelper = internationalizationHelper;
    }

    @Override
    protected JsTreeNode doBuild(JsTreeNode node, Iteration model) {
        node.addAttr("name", HtmlUtils.htmlEscape((String)model.getName()));
        node.addAttr("reference", HtmlUtils.htmlEscape((String)model.getReference()));
        node.setTitle(HtmlUtils.htmlEscape((String)model.getFullName()));
        node.addAttr("rel", "iteration");
        node.addAttr("resId", String.valueOf(model.getId()));
        node.addAttr("resType", "iterations");
        node.setState(model.hasTestSuites() ? JsTreeNode.State.closed : JsTreeNode.State.leaf);
        node.addAttr("iterationIndex", Integer.toString(this.index + 1));
        node.addAttr("id", String.valueOf(model.getClass().getSimpleName()) + '-' + model.getId());
        node.addAttr("milestones", (Number)model.getMilestones().size());
        node.addAttr("milestone-creatable-deletable", model.doMilestonesAllowCreation().toString());
        node.addAttr("milestone-editable", model.doMilestonesAllowEdition().toString());
        return node;
    }

    @Override
    protected void doAddChildren(JsTreeNode node, Iteration model) {
        if (model.hasContent()) {
            TestSuiteNodeBuilder childrenBuilder = new TestSuiteNodeBuilder(this.permissionEvaluationService, this.internationalizationHelper);
            List<JsTreeNode> children = new JsTreeNodeListBuilder<TestSuite>(childrenBuilder).expand(this.getExpansionCandidates()).setModel(model.getOrderedContent()).build();
            node.setChildren(children);
            JsTreeNode.State state = children.isEmpty() ? JsTreeNode.State.leaf : JsTreeNode.State.open;
            node.setState(state);
        }
    }
}

