/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.MultiMap;
import org.squashtest.tm.api.security.acls.Permission;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.NodeClassNameReader;

public abstract class GenericJsTreeNodeBuilder<MODEL extends Identified, BUILDER extends JsTreeNodeBuilder<MODEL, BUILDER>>
implements JsTreeNodeBuilder<MODEL, BUILDER> {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private static final Permission[] NODE_PERMISSIONS = new Permission[]{Permission.WRITE, Permission.CREATE, Permission.DELETE, Permission.EXECUTE, Permission.EXPORT};
    private static final String[] PERM_NAMES = new String[]{Permission.WRITE.name(), Permission.CREATE.name(), Permission.DELETE.name(), Permission.EXECUTE.name(), Permission.EXPORT.name()};
    private static final String UNCHECKED = "unchecked";
    protected final PermissionEvaluationService permissionEvaluationService;
    protected Milestone milestoneFilter;
    protected int index;
    private MODEL model;
    private MultiMap expansionCandidates;

    protected GenericJsTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService) {
        this.permissionEvaluationService = permissionEvaluationService;
        assert (PERM_NAMES.length == NODE_PERMISSIONS.length);
    }

    @Override
    public final BUILDER setModel(MODEL model) {
        this.model = model;
        return (BUILDER)this;
    }

    @Override
    public final JsTreeNode build() {
        JsTreeNode node = new JsTreeNode();
        Map permByName = this.getPermissionEvaluationService().hasRoleOrPermissionsOnObject(ROLE_ADMIN, PERM_NAMES, this.model);
        Permission[] permissionArray = NODE_PERMISSIONS;
        int n = NODE_PERMISSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Permission perm = permissionArray[n2];
            node.addAttr(perm.getQuality(), ((Boolean)permByName.get(perm.name())).toString());
            ++n2;
        }
        if ((node = this.doBuild(node, this.model)) != null && this.shouldExpandModel()) {
            this.doAddChildren(node, this.model);
        }
        return node;
    }

    protected boolean shouldExpandModel() {
        if (this.expansionCandidates == null || this.expansionCandidates.isEmpty()) {
            return false;
        }
        Collection candidateIds = (Collection)this.expansionCandidates.get((Object)this.modelShortClassName());
        return candidateIds != null && candidateIds.contains(this.model.getId());
    }

    private String modelShortClassName() {
        String className;
        if (this.model instanceof NodeContainer) {
            NodeClassNameReader classNameReader = new NodeClassNameReader();
            ((NodeContainer)this.model).accept((NodeContainerVisitor)classNameReader);
            className = classNameReader.getSimpleName();
        } else if (this.model instanceof TreeNode) {
            NodeClassNameReader classNameReader = new NodeClassNameReader();
            ((TreeNode)this.model).accept((NodeVisitor)classNameReader);
            className = classNameReader.getSimpleName();
        } else {
            className = this.model.getClass().getSimpleName();
        }
        return className;
    }

    protected abstract JsTreeNode doBuild(JsTreeNode var1, MODEL var2);

    protected abstract void doAddChildren(JsTreeNode var1, MODEL var2);

    @Override
    public BUILDER expand(MultiMap expansionCandidates) {
        this.expansionCandidates = expansionCandidates;
        return (BUILDER)this;
    }

    protected MultiMap getExpansionCandidates() {
        return this.expansionCandidates;
    }

    public PermissionEvaluationService getPermissionEvaluationService() {
        return this.permissionEvaluationService;
    }

    @Override
    public BUILDER setIndex(int index) {
        this.index = index;
        return (BUILDER)this;
    }

    @Override
    public BUILDER filterByMilestone(Milestone milestone) {
        this.milestoneFilter = milestone;
        return (BUILDER)this;
    }
}

