/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.helper.LabelFormatter;

public class EnumJeditableComboDataBuilder<T extends Enum<?>, B extends EnumJeditableComboDataBuilder<T, B>> {
    private Locale locale;
    private List<T> model;
    private Comparator<? super T> modelComparator;
    private LabelFormatter<? super T> labelFormatter;
    private T selectedItem;

    public void setModel(@NotNull List<T> model) {
        this.model = model;
    }

    public void setModelComparator(Comparator<? super T> comparator) {
        this.modelComparator = comparator;
    }

    public void setLabelFormatter(LabelFormatter<? super T> formatter) {
        this.labelFormatter = formatter;
    }

    public void setModel(@NotNull T[] model) {
        this.model = Arrays.asList(model);
    }

    public String buildMarshalled() {
        return JsonHelper.serialize(this.buildMap());
    }

    public Map<String, String> buildMap() {
        this.sortModelIfRequired();
        Map<String, String> comboData = this.createComboData();
        this.addSelectedItemIfRequired(comboData);
        return comboData;
    }

    private Map<String, String> createComboData() {
        LinkedHashMap<String, String> comboData = new LinkedHashMap<String, String>(this.model.size());
        this.labelFormatter.useLocale(this.locale);
        for (Enum item : this.model) {
            comboData.put(this.itemKey(item), this.labelFormatter.formatLabel(item));
        }
        return comboData;
    }

    protected String itemKey(T item) {
        return ((Enum)item).name();
    }

    private void addSelectedItemIfRequired(Map<String, String> comboData) {
        if (this.selectedItem != null) {
            comboData.put("selected", ((Enum)this.selectedItem).name());
        }
    }

    private void sortModelIfRequired() {
        if (this.modelComparator != null) {
            Collections.sort(this.model, this.modelComparator);
        }
    }

    public B selectItem(T selectedItem) {
        this.selectedItem = selectedItem;
        return (B)this;
    }

    public B useLocale(Locale locale) {
        this.locale = locale;
        return (B)this;
    }

    protected final T getSelectedItem() {
        return this.selectedItem;
    }
}

