/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Collection;
import java.util.List;
import javax.inject.Provider;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.security.acls.Permission;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.internal.helper.HyphenedStringHelper;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.model.builder.GenericJsTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;
import org.squashtest.tm.web.internal.model.builder.LibraryTreeNodeBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class DriveNodeBuilder<LN extends LibraryNode>
extends GenericJsTreeNodeBuilder<Library<LN>, DriveNodeBuilder<LN>> {
    private final Provider<? extends LibraryTreeNodeBuilder<LN>> childrenBuilderProvider;

    public DriveNodeBuilder(PermissionEvaluationService permissionEvaluationService, Provider<? extends LibraryTreeNodeBuilder<LN>> childrenBuilderProvider) {
        super(permissionEvaluationService);
        this.childrenBuilderProvider = childrenBuilderProvider;
    }

    @Override
    protected JsTreeNode doBuild(JsTreeNode node, Library<LN> model) {
        boolean manageable = this.getPermissionEvaluationService().hasRoleOrPermissionOnObject("ROLE_ADMIN", Permission.MANAGEMENT.name(), model);
        boolean importable = this.getPermissionEvaluationService().hasRoleOrPermissionOnObject("ROLE_ADMIN", Permission.IMPORT.name(), model);
        node.addAttr("manageable", Boolean.toString(manageable));
        node.addAttr("importable", Boolean.toString(importable));
        node.addAttr("rel", "drive");
        node.addAttr("resId", String.valueOf(model.getId()));
        node.addAttr("resType", this.buildResourceType(model.getClassSimpleName()));
        node.setState(model.hasContent() ? JsTreeNode.State.closed : JsTreeNode.State.leaf);
        node.setTitle(HtmlUtils.htmlEscape((String)model.getProject().getName()));
        node.addAttr("name", model.getClassSimpleName());
        node.addAttr("id", String.valueOf(model.getClassSimpleName()) + '-' + model.getId());
        node.addAttr("title", HTMLCleanupUtils.escapeOrDefault(model.getProject().getLabel(), ""));
        node.addAttr("project", (Number)model.getProject().getId());
        node.addAttr("wizards", (Collection)model.getEnabledPlugins());
        node.addAttr("milestone-creatable-deletable", "true");
        node.addAttr("milestone-editable", "true");
        return node;
    }

    private String buildResourceType(String classSimpleName) {
        String singleResourceType = HyphenedStringHelper.camelCaseToHyphened((String)classSimpleName);
        return singleResourceType.replaceAll("y$", "ies");
    }

    @Override
    protected void doAddChildren(JsTreeNode node, Library<LN> model) {
        if (model.hasContent()) {
            LibraryTreeNodeBuilder builder = (LibraryTreeNodeBuilder)this.childrenBuilderProvider.get();
            if (this.milestoneFilter != null) {
                builder.filterByMilestone(this.milestoneFilter);
            }
            List<JsTreeNode> children = new JsTreeNodeListBuilder(builder).expand(this.getExpansionCandidates()).setModel(model.getOrderedContent()).build();
            node.setChildren(children);
            JsTreeNode.State state = children.isEmpty() ? JsTreeNode.State.leaf : JsTreeNode.State.open;
            node.setState(state);
        }
    }
}

