/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Map;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.security.acls.Permission;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component(value="customReport.nodeBuilder")
@Scope(value="prototype")
public class CustomReportTreeNodeBuilder {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private static final Permission[] NODE_PERMISSIONS = new Permission[]{Permission.WRITE, Permission.CREATE, Permission.DELETE, Permission.EXECUTE, Permission.EXPORT};
    private static final String[] PERM_NAMES = new String[]{Permission.WRITE.name(), Permission.CREATE.name(), Permission.DELETE.name(), Permission.EXECUTE.name(), Permission.EXPORT.name()};
    private final PermissionEvaluationService permissionEvaluationService;

    @Inject
    public CustomReportTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService) {
        this.permissionEvaluationService = permissionEvaluationService;
    }

    public JsTreeNode build(CustomReportLibraryNode crln) {
        JsTreeNode builtNode = new JsTreeNode();
        builtNode.setTitle(HtmlUtils.htmlEscape((String)crln.getName()));
        builtNode.addAttr("resId", String.valueOf(crln.getId()));
        builtNode.addAttr("name", HtmlUtils.htmlEscape((String)crln.getName()));
        builtNode.addAttr("milestone-creatable-deletable", "true");
        builtNode.addAttr("milestone-editable", "true");
        this.doPermissionCheck(builtNode, crln);
        CustomReportTreeDefinition entityType = crln.getEntityType();
        switch (entityType) {
            case LIBRARY: {
                this.doLibraryBuild(builtNode, crln);
                break;
            }
            case FOLDER: {
                this.doFolderBuild(builtNode, crln);
                break;
            }
            case CHART: {
                this.doChartBuild(builtNode, crln);
                break;
            }
            case REPORT: {
                this.doReportBuild(builtNode, crln);
                break;
            }
            case DASHBOARD: {
                this.doDashboardBuild(builtNode, crln);
                break;
            }
            case CUSTOM_EXPORT: {
                this.doCustomExportBuild(builtNode, crln);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The node builder isn't implemented for node of type : " + entityType);
            }
        }
        return builtNode;
    }

    private void doLibraryBuild(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        this.setNodeHTMLId(builtNode, "CustomReportLibrary-" + crln.getId());
        this.setNodeRel(builtNode, "drive");
        this.setNodeResType(builtNode, "custom-report-libraries");
        this.setStateForNodeContainer(builtNode, (TreeLibraryNode)crln);
    }

    private void doFolderBuild(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        this.setNodeHTMLId(builtNode, "CustomReportFolder-" + crln.getId());
        this.setNodeRel(builtNode, "folder");
        this.setNodeResType(builtNode, "custom-report-folders");
        this.setStateForNodeContainer(builtNode, (TreeLibraryNode)crln);
    }

    private void doChartBuild(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        this.setNodeHTMLId(builtNode, "CustomReportChart-" + crln.getId());
        this.setNodeRel(builtNode, "chart");
        this.setNodeResType(builtNode, "custom-report-chart");
        this.setNodeLeaf(builtNode);
    }

    private void doReportBuild(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        this.setNodeHTMLId(builtNode, "CustomReportReport-" + crln.getId());
        this.setNodeRel(builtNode, "report");
        this.setNodeResType(builtNode, "custom-report-report");
        this.setNodeLeaf(builtNode);
    }

    private void doDashboardBuild(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        this.setNodeHTMLId(builtNode, "CustomReportDashboard-" + crln.getId());
        this.setNodeRel(builtNode, "dashboard");
        this.setNodeResType(builtNode, "custom-report-dashboard");
        this.setStateForNodeContainer(builtNode, (TreeLibraryNode)crln);
    }

    private void doCustomExportBuild(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        this.setNodeHTMLId(builtNode, "CustomExport-" + crln.getId());
        this.setNodeRel(builtNode, "custom-export");
        this.setNodeResType(builtNode, "custom-report-custom-export");
        this.setStateForNodeContainer(builtNode, (TreeLibraryNode)crln);
    }

    private void doPermissionCheck(JsTreeNode builtNode, CustomReportLibraryNode crln) {
        Map permByName = this.permissionEvaluationService.hasRoleOrPermissionsOnObject(ROLE_ADMIN, PERM_NAMES, (Object)crln);
        Permission[] permissionArray = NODE_PERMISSIONS;
        int n = NODE_PERMISSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Permission perm = permissionArray[n2];
            builtNode.addAttr(perm.getQuality(), ((Boolean)permByName.get(perm.name())).toString());
            ++n2;
        }
    }

    private void setStateForNodeContainer(JsTreeNode builtNode, TreeLibraryNode tln) {
        if (tln.hasContent()) {
            builtNode.setState(JsTreeNode.State.closed);
        } else {
            builtNode.setState(JsTreeNode.State.leaf);
        }
    }

    private void setNodeRel(JsTreeNode builtNode, String rel) {
        builtNode.addAttr("rel", rel);
    }

    private void setNodeResType(JsTreeNode builtNode, String resType) {
        builtNode.addAttr("resType", resType);
    }

    private void setNodeLeaf(JsTreeNode builtNode) {
        builtNode.setState(JsTreeNode.State.leaf);
    }

    private void setNodeHTMLId(JsTreeNode builtNode, String id) {
        builtNode.addAttr("id", id);
    }
}

