/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.List;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignLibraryNodeVisitor;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.IterationNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;
import org.squashtest.tm.web.internal.model.builder.LibraryTreeNodeBuilder;

@Component
@Scope(value="prototype")
public class CampaignLibraryTreeNodeBuilder
extends LibraryTreeNodeBuilder<CampaignLibraryNode> {
    protected InternationalizationHelper internationalizationHelper;

    @Inject
    public CampaignLibraryTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService, InternationalizationHelper internationalizationHelper) {
        super(permissionEvaluationService);
        this.internationalizationHelper = internationalizationHelper;
    }

    @Override
    protected void addCustomAttributes(CampaignLibraryNode libraryNode, JsTreeNode treeNode) {
        libraryNode.accept((CampaignLibraryNodeVisitor)new CustomAttributesPopulator(treeNode));
    }

    @Override
    protected void doAddChildren(JsTreeNode node, CampaignLibraryNode model) {
        model.accept((CampaignLibraryNodeVisitor)new ChildrenPopulator(node));
    }

    @Override
    protected boolean passesMilestoneFilter() {
        if (this.milestoneFilter != null) {
            return new MilestoneFilter(this.milestoneFilter).isValid((CampaignLibraryNode)this.node);
        }
        return true;
    }

    private class ChildrenPopulator
    implements CampaignLibraryNodeVisitor {
        private final JsTreeNode builtNode;

        public ChildrenPopulator(JsTreeNode builtNode) {
            this.builtNode = builtNode;
        }

        public void visit(Campaign visited) {
            if (visited.hasContent()) {
                this.builtNode.setState(JsTreeNode.State.open);
                IterationNodeBuilder childrenBuilder = new IterationNodeBuilder(CampaignLibraryTreeNodeBuilder.this.permissionEvaluationService, CampaignLibraryTreeNodeBuilder.this.internationalizationHelper);
                List<JsTreeNode> children = new JsTreeNodeListBuilder<Iteration>(childrenBuilder).expand(CampaignLibraryTreeNodeBuilder.this.getExpansionCandidates()).setModel(visited.getOrderedContent()).build();
                this.builtNode.setChildren(children);
            }
        }

        public void visit(CampaignFolder visited) {
            if (visited.hasContent()) {
                CampaignLibraryTreeNodeBuilder childrenBuilder = new CampaignLibraryTreeNodeBuilder(CampaignLibraryTreeNodeBuilder.this.permissionEvaluationService, CampaignLibraryTreeNodeBuilder.this.internationalizationHelper);
                childrenBuilder.filterByMilestone(CampaignLibraryTreeNodeBuilder.this.milestoneFilter);
                List<JsTreeNode> children = new JsTreeNodeListBuilder<CampaignLibraryNode>(childrenBuilder).expand(CampaignLibraryTreeNodeBuilder.this.getExpansionCandidates()).setModel(visited.getOrderedContent()).build();
                this.builtNode.setChildren(children);
                JsTreeNode.State state = children.isEmpty() ? JsTreeNode.State.leaf : JsTreeNode.State.open;
                this.builtNode.setState(state);
            }
        }
    }

    private class CustomAttributesPopulator
    implements CampaignLibraryNodeVisitor {
        private final JsTreeNode builtNode;

        public CustomAttributesPopulator(JsTreeNode builtNode) {
            this.builtNode = builtNode;
        }

        public void visit(CampaignFolder folder) {
            CampaignLibraryTreeNodeBuilder.this.addFolderAttributes("campaign-folders");
            JsTreeNode.State state = folder.hasContent() ? JsTreeNode.State.closed : JsTreeNode.State.leaf;
            this.builtNode.setState(state);
        }

        public void visit(Campaign campaign) {
            this.builtNode.addAttr("name", HtmlUtils.htmlEscape((String)campaign.getName()));
            this.builtNode.addAttr("reference", HtmlUtils.htmlEscape((String)campaign.getReference()));
            this.builtNode.setTitle(HtmlUtils.htmlEscape((String)campaign.getFullName()));
            this.builtNode.addAttr("rel", "campaign");
            this.builtNode.addAttr("resType", "campaigns");
            JsTreeNode.State state = campaign.hasIterations() ? JsTreeNode.State.closed : JsTreeNode.State.leaf;
            this.builtNode.setState(state);
            this.builtNode.addAttr("milestones", (Number)campaign.getMilestones().size());
            this.builtNode.addAttr("milestone-creatable-deletable", campaign.doMilestonesAllowCreation().toString());
            this.builtNode.addAttr("milestone-editable", campaign.doMilestonesAllowEdition().toString());
        }
    }

    private static final class MilestoneFilter
    implements CampaignLibraryNodeVisitor {
        private Milestone milestone;
        private boolean isValid;

        private MilestoneFilter(Milestone milestone) {
            this.milestone = milestone;
        }

        public boolean isValid(CampaignLibraryNode node) {
            this.isValid = false;
            node.accept((CampaignLibraryNodeVisitor)this);
            return this.isValid;
        }

        public void visit(CampaignFolder folder) {
            this.isValid = true;
        }

        public void visit(Campaign campaign) {
            this.isValid = campaign.isMemberOf(this.milestone);
        }
    }
}

