/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.listener;

import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.web.internal.annotation.ApplicationComponent;

@ApplicationComponent
public class SquashConfigContextExposer
implements ServletContextListener,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashConfigContextExposer.class);
    public static final String MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR = "milestoneFeatureEnabled";
    private volatile ServletContextEvent sce;
    private volatile boolean contextReady = false;
    @Inject
    private ConfigurationService configurationService;

    public void contextInitialized(ServletContextEvent sce) {
        this.sce = sce;
        this.exposeMilestoneFeatEnabled();
    }

    private synchronized void exposeMilestoneFeatEnabled() {
        if (this.sce == null || !this.contextReady) {
            return;
        }
        boolean enabled = this.configurationService.getBoolean("feature.milestone.enabled");
        LOGGER.info("Read global configuration param '{}' with param '{}'", (Object)"feature.milestone.enabled", (Object)enabled);
        this.sce.getServletContext().setAttribute(MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR, (Object)enabled);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.contextReady = true;
        this.exposeMilestoneFeatEnabled();
    }
}

