/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.listener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.squashtest.tm.web.internal.interceptor.openedentity.OpenedEntities;

public class OpenedEntitiesLifecycleListener
implements HttpSessionListener,
ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenedEntitiesLifecycleListener.class);

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        ServletContext context = event.getSession().getServletContext();
        HttpSession session = event.getSession();
        SecurityContext securityContext = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
        String login = this.retrieveLogin(securityContext);
        this.unregisterLogin(context, login);
    }

    private void unregisterLogin(ServletContext context, String login) {
        if (login != null) {
            LOGGER.debug("Session Closed for user {}", (Object)login);
            for (String managedEntityKey : OpenedEntities.MANAGED_ENTITIES_LIST) {
                this.removeUserFromViewers(managedEntityKey, login, context);
            }
        }
    }

    private String retrieveLogin(SecurityContext securityContext) {
        Authentication authentication;
        String login = null;
        if (securityContext != null && (authentication = securityContext.getAuthentication()) != null) {
            login = authentication.getName();
        }
        return login;
    }

    private void removeUserFromViewers(String managedEntityKey, String login, ServletContext context) {
        OpenedEntities openedEntities = (OpenedEntities)context.getAttribute(managedEntityKey);
        if (openedEntities != null) {
            openedEntities.removeViewer(login);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        for (String contextAttributeName : OpenedEntities.MANAGED_ENTITIES_LIST) {
            OpenedEntities entities = new OpenedEntities();
            context.setAttribute(contextAttributeName, (Object)entities);
        }
    }
}

