/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.jsp.tags;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class JQueryTabsHeader
extends SimpleTagSupport {
    private static final String MAIN_DIV_FETCH_CLASS = "fragment-tabs";
    private static final String MAIN_MENU_FETCH_CLASS = "tab-menu";
    private static final String MAIN_DIV_ADDITIONAL_CLASSES = "ui-tabs ui-widget ui-widget-content ui-corner-all";
    private static final String MAIN_MENU_ADDITIONAL_CLASSES = "ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all";
    private static final String MAIN_MENUITEM_ADDITIONAL_CLASSES = "ui-state-default ui-corner-top";
    private static final String MAIN_MENUITEM_ACTIVE_ADD_CLASSES = " ui-tabs-active ui-state-active";
    private static final String MAIN_MENULINK_ADDITIONAL_CLASSES = "ui-tabs-anchor";
    private static final String CONTENT_ADDITIONAL_CLASSES = "ui-tabs-panel ui-widget-content ui-corner-bottom";
    private static final Pattern CLASS_MATCHER = Pattern.compile("(class=\"[^\"]+)");
    private static final Pattern STYLE_MATCHER = Pattern.compile("(style=\"[^\"]+)");
    private static final Pattern TAG_MATCHER = Pattern.compile("(<\\w+)");
    private static final String HREF_ATTRIBUTE = "href";
    private static final String LI_ELT = "li";
    private static final String A_ELT = "a";
    private static final String[] TAB_COOKIES = new String[]{"testcase-tab-cookie", "iteration-tab-cookie", "suite-tab-cookie"};
    private Collection<String> contentIds = new LinkedList<String>();
    private Source source;
    private OutputDocument output;
    private int activeContentIndex = 0;

    public void setActiveContentIndex(int activeContentIndex) {
        this.activeContentIndex = activeContentIndex;
    }

    public void doTag() throws JspException, IOException {
        JspFragment body = this.getJspBody();
        JspContext context = this.getJspContext();
        StringWriter writer = new StringWriter();
        body.invoke((Writer)writer);
        String strBody = writer.toString();
        this.source = new Source((CharSequence)strBody);
        this.output = new OutputDocument(this.source);
        this.modify();
        context.getOut().println(this.output.toString());
    }

    private void modify() {
        this.processMainDiv();
        this.processMainMenu();
        this.processContent();
    }

    private void processMainDiv() {
        List elements = this.source.getAllElementsByClass(MAIN_DIV_FETCH_CLASS);
        for (Element elt : elements) {
            this.process(elt, MAIN_DIV_ADDITIONAL_CLASSES);
        }
    }

    private void processMainMenu() {
        List elements = this.source.getAllElementsByClass(MAIN_MENU_FETCH_CLASS);
        for (Element elt : elements) {
            this.processMainMenuItems(elt);
            this.process(elt, MAIN_MENU_ADDITIONAL_CLASSES);
        }
    }

    private void processMainMenuItems(Element ulElt) {
        List elements = ulElt.getAllElements(LI_ELT);
        int counter = 0;
        for (Element elt : elements) {
            String css = MAIN_MENUITEM_ADDITIONAL_CLASSES;
            css = String.valueOf(css) + (counter == this.activeContentIndex ? MAIN_MENUITEM_ACTIVE_ADD_CLASSES : "");
            this.process(elt, css);
            ++counter;
        }
        this.processMainLinks(ulElt);
    }

    private void processMainLinks(Element ulElt) {
        List elements = ulElt.getAllElements(A_ELT);
        for (Element elt : elements) {
            String href = elt.getStartTag().getAttributeValue(HREF_ATTRIBUTE);
            if (href.matches("^#.*")) {
                this.contentIds.add(href.substring(1));
            }
            this.process(elt, MAIN_MENULINK_ADDITIONAL_CLASSES);
        }
    }

    private void processContent() {
        int counter = 0;
        for (String id : this.contentIds) {
            Element content = this.source.getElementById(id);
            String css = CONTENT_ADDITIONAL_CLASSES;
            boolean hide = counter != this.activeContentIndex;
            this.process(content, css, hide);
            ++counter;
        }
    }

    private void process(Element elt, String additionalClasses) {
        this.process(elt, additionalClasses, false);
    }

    private void process(Element elt, String additionalClasses, boolean hide) {
        StartTag sTag = elt.getStartTag();
        String html = sTag.toString();
        String processed = this.processClasses(html, additionalClasses);
        if (hide) {
            processed = this.processHide(processed);
        }
        this.output.replace((Segment)elt.getStartTag(), (CharSequence)processed);
    }

    private String processClasses(String html, String additionalClasses) {
        Matcher matcher = CLASS_MATCHER.matcher(html);
        String processed = matcher.find() ? matcher.replaceFirst("$1 " + additionalClasses) : TAG_MATCHER.matcher(html).replaceFirst("$1 class=\"" + additionalClasses + "\" ");
        return processed;
    }

    private String processHide(String html) {
        Matcher matcher = STYLE_MATCHER.matcher(html);
        String processed = matcher.find() ? matcher.replaceFirst("$1; display=none;") : TAG_MATCHER.matcher(html).replaceFirst("$1 style=\"display:none;\"");
        return processed;
    }
}

