/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.interceptor.openedentity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.web.internal.interceptor.openedentity.OpenedEntity;

public class OpenedEntities {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenedEntities.class);
    private Map<Long, OpenedEntity> entitiesViewers = new HashMap<Long, OpenedEntity>();
    public static final List<String> MANAGED_ENTITIES_LIST = Arrays.asList(TestCase.class.getSimpleName(), Requirement.class.getSimpleName(), Campaign.class.getSimpleName(), Iteration.class.getSimpleName(), TestSuite.class.getSimpleName(), Execution.class.getSimpleName());

    public synchronized boolean addViewerToEntity(Identified object, String userLogin) {
        OpenedEntity openedEntity = this.findOpenedEntity(object);
        return openedEntity.addViewForViewer(userLogin);
    }

    private synchronized OpenedEntity findOpenedEntity(Identified object) {
        OpenedEntity openedEntity = this.entitiesViewers.get(object.getId());
        if (openedEntity == null) {
            LOGGER.trace("Entity was not listed => new Entity");
            openedEntity = new OpenedEntity();
            this.entitiesViewers.put(object.getId(), openedEntity);
        } else {
            LOGGER.trace("Entity was already listed");
        }
        return openedEntity;
    }

    public synchronized void removeViewer(String viewerLogin) {
        for (Map.Entry<Long, OpenedEntity> entityViewers : this.entitiesViewers.entrySet()) {
            OpenedEntity openedEntity = entityViewers.getValue();
            openedEntity.removeAllViewsForViewer(viewerLogin);
        }
    }

    public synchronized void removeView(String name, Long id) {
        OpenedEntity openedEntity = this.entitiesViewers.get(id);
        if (openedEntity != null) {
            openedEntity.removeViewForViewer(name);
        }
    }
}

