/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.interceptor.openedentity;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.interceptor.openedentity.OpenedEntities;

public abstract class ObjectViewsInterceptor
implements WebRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectViewsInterceptor.class);
    @Inject
    @Lazy
    protected ServletContext context;
    @Inject
    @Lazy
    private PermissionEvaluationService permissionService;

    protected final boolean addViewerToEntity(String contextAttributeName, Identified object, String userLogin) {
        LOGGER.debug("New view added for {} = {}  Viewer = {}", new Object[]{contextAttributeName, object.getId(), userLogin});
        boolean otherViewers = false;
        if (this.permissionService.hasMoreThanRead((Object)object)) {
            LOGGER.debug("User has more than readonly in object = true");
            OpenedEntities openedEntities = (OpenedEntities)this.context.getAttribute(contextAttributeName);
            if (openedEntities != null) {
                otherViewers = openedEntities.addViewerToEntity(object, userLogin);
            }
        } else {
            LOGGER.debug("User has more than readonly in object = false");
        }
        return otherViewers;
    }
}

