/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.interceptor;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class SecurityExpressionResolverExposerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityExpressionResolverExposerInterceptor.class);
    @Inject
    private PermissionEvaluator permissionEvaluator;
    private static final FilterChain DUMMY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }
    };
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        if (modelAndView != null && modelAndView.hasView() && !StringUtils.startsWith((CharSequence)modelAndView.getViewName(), (CharSequence)"redirect:")) {
            FilterInvocation filterInvocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, DUMMY_CHAIN);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null) {
                LOGGER.debug("No authentication available for '{}{}'. Thymeleaf won't have access to '#sec' in view '{}'", new Object[]{request.getServletPath(), request.getPathInfo(), modelAndView.getViewName()});
                return;
            }
            WebSecurityExpressionRoot expressionRoot = new WebSecurityExpressionRoot(authentication, filterInvocation);
            expressionRoot.setTrustResolver(this.trustResolver);
            expressionRoot.setPermissionEvaluator(this.permissionEvaluator);
            modelAndView.addObject("sec", (Object)expressionRoot);
        }
    }
}

