/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.helper;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.api.export.ExportPlugin;
import org.squashtest.tm.api.wizard.WorkspacePlugin;
import org.squashtest.tm.api.wizard.WorkspacePluginIcon;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.dto.FilterModel;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.testautomation.TestAutomationProjectFinderService;
import org.squashtest.tm.service.workspace.WorkspaceHelperService;
import org.squashtest.tm.service.workspace.WorkspacePluginManager;
import org.squashtest.tm.web.internal.plugins.manager.export.ExportPluginManager;
import org.squashtest.tm.web.internal.plugins.manager.wizard.WorkspaceWizardManager;

public class WorkspaceHelper
extends SimpleTagSupport {
    public static Collection<BugTracker> getVisibleBugtrackers(ServletContext context) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        ProjectFinder projectFinder = (ProjectFinder)wac.getBean(ProjectFinder.class);
        BugTrackerFinderService bugtrackerService = (BugTrackerFinderService)wac.getBean(BugTrackerFinderService.class);
        List projectsIds = projectFinder.findAllReadableIds();
        return bugtrackerService.findDistinctBugTrackersForProjects(projectsIds);
    }

    public static Collection<WorkspacePluginIcon> getAuthorizedWorkspacePluginIcons(ServletContext context) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        WorkspacePluginManager workspacePluginManager = (WorkspacePluginManager)wac.getBean(WorkspacePluginManager.class);
        return workspacePluginManager.getAllAuthorized().stream().map(WorkspacePlugin::getWorkspaceIcon).collect(Collectors.toList());
    }

    public static URL getAutomatedJobURL(ServletContext context, Long executionId) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        ExecutionModificationService exService = (ExecutionModificationService)wac.getBean(ExecutionModificationService.class);
        TestAutomationProjectFinderService projFinder = (TestAutomationProjectFinderService)wac.getBean(TestAutomationProjectFinderService.class);
        Execution exec = exService.findById(executionId.longValue());
        if (exec.isAutomated() && !exec.getAutomatedExecutionExtender().isProjectDisassociated()) {
            return projFinder.findProjectURL(exec.getAutomatedExecutionExtender().getAutomatedProject());
        }
        return null;
    }

    public static Collection<ExportPlugin> getExportPlugins(ServletContext context, String workspaceName) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        WorkspaceType workspace = WorkspaceType.valueOf((String)workspaceName);
        ExportPluginManager manager = (ExportPluginManager)wac.getBean(ExportPluginManager.class);
        return manager.findAllByWorkspace(workspace);
    }

    public static Collection<WorkspaceWizard> getWizardPlugins(ServletContext context, String workspaceName) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        WorkspaceWizardManager wizardManager = (WorkspaceWizardManager)wac.getBean(WorkspaceWizardManager.class);
        WorkspaceType type = WorkspaceType.valueOf((String)workspaceName);
        return wizardManager.findAllByWorkspace(type);
    }

    public static FilterModel getProjectFilter(ServletContext context) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        WorkspaceHelperService service = (WorkspaceHelperService)wac.getBean(WorkspaceHelperService.class);
        return service.findFilterModel();
    }
}

