/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.helper;

import java.util.List;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.library.WorkspaceService;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;

public abstract class ModelTreeHelper {
    private ModelTreeHelper() {
    }

    public List<JsTreeNode> getRootModel(String[] openedNodes, String elementId) {
        String[] nodesToOpen;
        List libraries = this.getWorkspaceService().findAllLibraries();
        if (elementId == null || elementId.isEmpty()) {
            nodesToOpen = openedNodes;
        } else {
            Long id = Long.valueOf(elementId);
            nodesToOpen = this.getNodeParentsInWorkspace(id);
        }
        MultiMap expansionCandidates = this.mapIdsByType(nodesToOpen);
        DriveNodeBuilder nodeBuilder = (DriveNodeBuilder)this.driveNodeBuilderProvider().get();
        List<JsTreeNode> rootNodes = new JsTreeNodeListBuilder(nodeBuilder).expand(expansionCandidates).setModel(libraries).build();
        return rootNodes;
    }

    protected abstract WorkspaceService<Library<LibraryNode>> getWorkspaceService();

    protected abstract String[] getNodeParentsInWorkspace(Long var1);

    protected MultiMap mapIdsByType(String[] openedNodes) {
        return JsTreeHelper.mapIdsByType(openedNodes);
    }

    protected abstract Provider<DriveNodeBuilder<LibraryNode>> driveNodeBuilderProvider();
}

