/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.helper;

import java.util.Locale;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.web.internal.helper.LabelFormatter;

@Component
@Scope(value="prototype")
public class InternationalizableLabelFormatter
implements LabelFormatter<Internationalizable> {
    private final MessageSource messageSource;
    private Locale locale = Locale.getDefault();
    private boolean escapeHtml = true;

    @Inject
    public InternationalizableLabelFormatter(@NotNull MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public LabelFormatter<Internationalizable> useLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public String formatLabel(Internationalizable toFormat) {
        String label = this.messageSource.getMessage(toFormat.getI18nKey(), null, this.locale);
        return this.escapeHtml ? StringEscapeUtils.escapeHtml4((String)label) : label;
    }

    @Override
    public LabelFormatter<Internationalizable> escapeHtml() {
        this.escapeHtml = true;
        return this;
    }

    @Override
    public LabelFormatter<Internationalizable> plainText() {
        this.escapeHtml = false;
        return this;
    }
}

