/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.helper;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.service.infolist.InfoListFinderService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.i18n.MessageObject;

@Component
public class I18nLevelEnumInfolistHelper {
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private InfoListFinderService infoListFinder;

    public MessageObject getInternationalizedDefaultList(Locale locale) {
        HashMap<String, InfoList> listMap = new HashMap<String, InfoList>();
        listMap.put("REQUIREMENT_VERSION_CATEGORY", this.infoListFinder.findByCode(SystemInfoListCode.REQUIREMENT_CATEGORY.getCode()));
        listMap.put("TEST_CASE_NATURE", this.infoListFinder.findByCode(SystemInfoListCode.TEST_CASE_NATURE.getCode()));
        listMap.put("TEST_CASE_TYPE", this.infoListFinder.findByCode(SystemInfoListCode.TEST_CASE_TYPE.getCode()));
        MessageObject mapItems = new MessageObject();
        for (InfoList infoList : listMap.values()) {
            List infoListItems = infoList.getItems();
            for (InfoListItem infoListItem : infoListItems) {
                mapItems.put(infoListItem.getLabel(), infoListItem.getLabel());
            }
        }
        this.i18nHelper.resolve(mapItems, locale);
        return mapItems;
    }

    public <E extends Enum<E>> MessageObject getI18nLevelEnum(Class<E> clazz, Locale locale) {
        MessageObject i18nEnums = new MessageObject();
        EnumSet<Enum> levels = EnumSet.allOf(clazz);
        for (Enum level : levels) {
            i18nEnums.put(level.name(), ((Level)level).getI18nKey());
        }
        this.i18nHelper.resolve(i18nEnums, locale);
        return i18nEnums;
    }
}

