/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;

public final class UserCredentialsCachePersistenceFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserCredentialsCachePersistenceFilter.class);
    public static final String CREDENTIALS_CACHE_SESSION_KEY = "squashtest.servers.UserCredentialsCache";
    private CredentialsProvider credentialsProvider;
    private final List<String> excludePatterns = new ArrayList<String>();
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String url = String.valueOf(request.getServletPath()) + StringUtils.defaultString((String)request.getPathInfo());
        if (!this.matchExcludePatterns(url)) {
            try {
                UserCredentialsCache credentialsCache = this.loadFromSession((ServletRequest)request);
                if (credentialsCache != null) {
                    this.credentialsProvider.restoreCache(credentialsCache);
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                UserCredentialsCache credentialsCache = this.credentialsProvider.getCache();
                this.credentialsProvider.unloadCache();
                if (credentialsCache != null) {
                    this.storeCredentialsCacheInExistingSession((ServletRequest)request, credentialsCache);
                }
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean matchExcludePatterns(String url) {
        boolean match = false;
        for (String pattern : this.excludePatterns) {
            if (!this.pathMatcher.match(pattern, url)) continue;
            match = true;
            break;
        }
        return match;
    }

    private void storeCredentialsCacheInExistingSession(ServletRequest request, UserCredentialsCache context) {
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session == null) {
            LOGGER.info("UserCredentialsCachePersistenceFilter : Session was invalidated, UserCredentialsCache will not be stored");
            return;
        }
        this.storeCredentialsCache(session, context);
        LOGGER.debug("UserCredentialsCachePersistenceFilter : UserCredentialsCache stored to session");
    }

    private void storeCredentialsCache(HttpSession session, UserCredentialsCache credentials) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("UserCredentialsCachePersistenceFilter : storing credentials cache for session #{} with credentials #{}", (Object)session.getId(), (Object)credentials.toString());
        }
        session.setAttribute(CREDENTIALS_CACHE_SESSION_KEY, (Object)credentials);
    }

    private UserCredentialsCache loadFromSession(ServletRequest request) {
        LOGGER.debug("UserCredentialsCachePersistenceFilter : Loading UserCredentialsCache from HTTP session");
        HttpSession session = ((HttpServletRequest)request).getSession();
        UserCredentialsCache credentialsCache = (UserCredentialsCache)session.getAttribute(CREDENTIALS_CACHE_SESSION_KEY);
        if (LOGGER.isTraceEnabled()) {
            if (credentialsCache != null) {
                LOGGER.trace("UserCredentialsCachePersistenceFilter : Loading credentials for session #{} with credentials #{}", (Object)session.getId(), (Object)credentialsCache.toString());
            } else {
                LOGGER.trace("UserCredentialsCachePersistenceFilter : no credentials cache found for session #{}", (Object)session.getId());
            }
        }
        return credentialsCache;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public UserCredentialsCachePersistenceFilter addExcludePatterns(String ... antPatterns) {
        this.excludePatterns.addAll(Arrays.asList(antPatterns));
        return this;
    }
}

