/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.internal.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.internal.exceptionresolver.FieldValidationErrorModel;
import org.squashtest.tm.web.internal.exceptionresolver.MimeType;

@ControllerAdvice
public class HandlerTransactionSystemExceptionResolver
extends AbstractHandlerExceptionResolver {
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex) && ExceptionResolverUtils.clientAcceptsMIMEOrAnything(request, MimeType.APPLICATION_JSON)) {
            response.setStatus(412);
            ConstraintViolationException bex = (ConstraintViolationException)ex.getCause().getCause();
            List<FieldValidationErrorModel> errors = this.buildFieldValidationErrors(bex);
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", errors);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(ConstraintViolationException cve) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        Set violations = cve.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            ves.add(new FieldValidationErrorModel(violation.getPropertyPath().toString(), violation.getPropertyPath().toString(), violation.getMessage()));
        }
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        Throwable rootCause;
        Throwable throwable = rootCause = ex.getCause() != null && ex.getCause().getCause() != null ? ex.getCause().getCause() : null;
        if (rootCause == null) {
            return false;
        }
        return rootCause instanceof ConstraintViolationException;
    }
}

