/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.exceptionresolver;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.core.foundation.exception.SimpleException;
import org.squashtest.tm.web.internal.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.internal.exceptionresolver.MimeType;

@Component
public class HandlerSimpleExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            return this.handleException(request, response, ex);
        }
        return null;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        SimpleException simpleEx = (SimpleException)ex;
        response.setStatus(412);
        String message = simpleEx.getMessage();
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.APPLICATION_JSON)) {
            return this.formatJsonResponse(message);
        }
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.TEXT_PLAIN)) {
            return this.formatPlainTextResponse(message);
        }
        return null;
    }

    private ModelAndView formatPlainTextResponse(String message) {
        PlainTextView view = new PlainTextView();
        return new ModelAndView((View)view, "simpleError", (Object)message);
    }

    private ModelAndView formatJsonResponse(String message) {
        return new ModelAndView((View)new MappingJackson2JsonView(), "error", (Object)message);
    }

    private boolean exceptionIsHandled(Exception ex) {
        return SimpleException.class.isAssignableFrom(ex.getClass());
    }

    private static class PlainTextView
    extends AbstractView {
        private PlainTextView() {
        }

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws IOException {
            String encoding = response.getCharacterEncoding();
            for (Object obj : model.values()) {
                response.getOutputStream().write(obj.toString().getBytes(encoding));
                response.getOutputStream().print('\n');
            }
        }
    }
}

