/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.core.scm.api.exception.ScmException;
import org.squashtest.tm.web.internal.exceptionresolver.ActionValidationErrorModel;
import org.squashtest.tm.web.internal.exceptionresolver.FieldValidationErrorModel;

@Component
public class HandlerScmExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            response.setStatus(412);
            ScmException scmException = (ScmException)ex;
            if (scmException.hasField()) {
                List<FieldValidationErrorModel> errors = this.buildFieldValidationErrors(scmException);
                return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", errors);
            }
            ActionValidationErrorModel model = new ActionValidationErrorModel(scmException.getClass().getSimpleName(), scmException.getMessage());
            return new ModelAndView((View)new MappingJackson2JsonView(), "actionValidationError", (Object)model);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(ScmException scmException) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        ves.add(new FieldValidationErrorModel("", scmException.getField(), scmException.getMessage()));
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof ScmException;
    }
}

