/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.exception.CompositeDomainException;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.web.internal.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.internal.exceptionresolver.FieldValidationErrorModel;
import org.squashtest.tm.web.internal.exceptionresolver.MimeType;

@Component
public class HandlerCompositeDomainExceptionResolver
extends AbstractHandlerExceptionResolver {
    @Inject
    private MessageSource messageSource;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex) && ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.APPLICATION_JSON)) {
            response.setStatus(412);
            CompositeDomainException cdex = (CompositeDomainException)ex;
            List<FieldValidationErrorModel> errors = this.buildFieldValidationErrors(cdex, request.getLocale());
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", errors);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(CompositeDomainException cdex, Locale locale) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        for (DomainException dex : cdex.getExceptions()) {
            String message = dex.getMessage();
            if (!dex.getI18nKey().isEmpty()) {
                message = this.messageSource.getMessage(dex.getI18nKey(), dex.getI18nParams(), locale);
            }
            ves.add(new FieldValidationErrorModel(dex.getObjectName(), dex.getField(), message, dex.getFieldValue()));
        }
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof CompositeDomainException;
    }
}

