/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.internal.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.internal.exceptionresolver.FieldValidationErrorModel;
import org.squashtest.tm.web.internal.exceptionresolver.MimeType;

@ControllerAdvice
public class HandlerBindExceptionResolver
extends AbstractHandlerExceptionResolver {
    @ExceptionHandler(value={BindException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex) && ExceptionResolverUtils.clientAcceptsMIMEOrAnything(request, MimeType.APPLICATION_JSON)) {
            response.setStatus(412);
            BindException bex = (BindException)ex;
            List<FieldValidationErrorModel> errors = this.buildFieldValidationErrors(bex);
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", errors);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(BindException bex) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        List oes = bex.getFieldErrors();
        for (FieldError oe : oes) {
            ves.add(new FieldValidationErrorModel(oe.getObjectName(), oe.getField(), oe.getDefaultMessage()));
        }
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof BindException;
    }
}

