/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.exceptionresolver;

import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.web.internal.exceptionresolver.ActionValidationErrorModel;
import org.squashtest.tm.web.internal.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.internal.exceptionresolver.MimeType;

@Component
public class HandlerActionExceptionResolver
extends AbstractHandlerExceptionResolver {
    @Inject
    private MessageSource messageSource;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            return this.handleException(request, response, ex);
        }
        return null;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ActionException actionEx = (ActionException)ex;
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.APPLICATION_JSON) || ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.ANYTHING)) {
            return this.formatJsonResponse(response, actionEx, request.getLocale());
        }
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.TEXT_PLAIN)) {
            return this.formatPlainTextResponse(response, actionEx, request.getLocale());
        }
        return null;
    }

    private ModelAndView formatPlainTextResponse(HttpServletResponse response, ActionException actionEx, Locale locale) {
        response.setStatus(412);
        String exception = actionEx.getClass().getSimpleName();
        String message = this.getLocalizedMessage(locale, actionEx);
        String error = String.valueOf(exception) + ':' + message;
        PlainTextView view = new PlainTextView();
        return new ModelAndView((View)view, "actionValidationError", (Object)error);
    }

    private ModelAndView formatJsonResponse(HttpServletResponse response, ActionException actionEx, Locale locale) {
        response.setStatus(412);
        String exception = actionEx.getClass().getSimpleName();
        String message = this.getLocalizedMessage(locale, actionEx);
        ActionValidationErrorModel error = new ActionValidationErrorModel(exception, message);
        return new ModelAndView((View)new MappingJackson2JsonView(), "actionValidationError", (Object)error);
    }

    private String getLocalizedMessage(Locale locale, ActionException actionEx) {
        String key = actionEx.getI18nKey();
        String message = null;
        if (key == null && actionEx.getMessage() != null && !actionEx.getMessage().isEmpty()) {
            message = actionEx.getMessage();
        } else if (key != null) {
            message = this.messageSource.getMessage(key, actionEx.messageArgs(), locale);
        }
        if (message == null) {
            message = this.messageSource.getMessage("error.generic.label", null, locale);
        }
        return message;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ActionException.class.isAssignableFrom(ex.getClass());
    }

    private static class PlainTextView
    extends AbstractView {
        private PlainTextView() {
        }

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            for (Object obj : model.values()) {
                response.getOutputStream().write(obj.toString().getBytes());
                response.getOutputStream().write(10);
            }
        }
    }
}

