/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.widget;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DataTablesController {
    @Inject
    private MessageSource messageSource;
    private Map<String, Object> legacyMessages;
    private Map<String, Object> messages;
    private Locale locale = Locale.getDefault();

    private void setLocale(Locale paramLocale) {
        this.locale = paramLocale != null ? paramLocale : Locale.getDefault();
    }

    @RequestMapping(value={"/datatables/messages"})
    @ResponseBody
    public Map<String, Object> getInternationalizedMessages(Locale paramLocale) {
        if (this.legacyMessages == null || !this.locale.equals(paramLocale)) {
            this.setLocale(paramLocale);
            this.legacyMessages = new HashMap<String, Object>();
            this.legacyMessages.put("sLengthMenu", this.messageSource.getMessage("generics.datatable.lengthMenu", null, paramLocale));
            this.legacyMessages.put("sZeroRecords", this.messageSource.getMessage("generics.datatable.zeroRecords", null, paramLocale));
            this.legacyMessages.put("sInfo", this.messageSource.getMessage("generics.datatable.info", null, paramLocale));
            this.legacyMessages.put("sInfoEmpty", this.messageSource.getMessage("generics.datatable.infoEmpty", null, paramLocale));
            this.legacyMessages.put("sInfoFiltered", this.messageSource.getMessage("generics.datatable.infoFiltered", null, paramLocale));
            this.legacyMessages.put("sSearch", this.messageSource.getMessage("generics.datatable.search", null, paramLocale));
            HashMap<String, String> pagination = new HashMap<String, String>();
            this.legacyMessages.put("oPaginate", pagination);
            pagination.put("sFirst", this.messageSource.getMessage("generics.datatable.paginate.first", null, paramLocale));
            pagination.put("sPrevious", this.messageSource.getMessage("generics.datatable.paginate.previous", null, paramLocale));
            pagination.put("sNext", this.messageSource.getMessage("generics.datatable.paginate.next", null, paramLocale));
            pagination.put("sLast", this.messageSource.getMessage("generics.datatable.paginate.last", null, paramLocale));
        }
        return this.legacyMessages;
    }

    @RequestMapping(value={"/datatables/language"})
    @ResponseBody
    public Map<String, Object> getLanguage(Locale locale) {
        if (this.messages == null) {
            this.messages = new HashMap<String, Object>();
            this.messages.put("search", this.messageSource.getMessage("generics.datatable.search", null, locale));
            this.messages.put("lengthMenu", this.messageSource.getMessage("generics.datatable.lengthMenu", null, locale));
            this.messages.put("info", this.messageSource.getMessage("generics.datatable.info", null, locale));
            this.messages.put("infoEmpty", this.messageSource.getMessage("generics.datatable.infoEmpty", null, locale));
            this.messages.put("infoFiltered", this.messageSource.getMessage("generics.datatable.infoFiltered", null, locale));
            this.messages.put("zeroRecords", this.messageSource.getMessage("generics.datatable.zeroRecords", null, locale));
            HashMap<String, String> pagination = new HashMap<String, String>();
            this.messages.put("paginate", pagination);
            pagination.put("first", this.messageSource.getMessage("generics.datatable.paginate.first", null, locale));
            pagination.put("previous", this.messageSource.getMessage("generics.datatable.paginate.previous", null, locale));
            pagination.put("next", this.messageSource.getMessage("generics.datatable.paginate.next", null, locale));
            pagination.put("last", this.messageSource.getMessage("generics.datatable.paginate.last", null, locale));
        }
        return this.messages;
    }
}

