/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.welcome;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.AdministrationService;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.internal.helper.I18nLevelEnumInfolistHelper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
public class HomeController {
    private AdministrationService administrationService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private BugTrackerFinderService bugtrackerService;
    @Inject
    private PartyPreferenceService partyPreferenceService;
    @Inject
    private I18nLevelEnumInfolistHelper i18nLevelEnumInfolistHelper;
    @Inject
    private CustomReportDashboardService customReportDashboardService;
    @Inject
    private ConfigurationService configurationService;

    @Inject
    public void setAdministrationService(AdministrationService administrationService) {
        this.administrationService = administrationService;
    }

    @RequestMapping(value={"/home-workspace"})
    public ModelAndView home(Locale locale) {
        String welcomeMessage = this.administrationService.findWelcomeMessage();
        Map userPrefs = this.partyPreferenceService.findPreferencesForCurrentUser();
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.HOME);
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.HOME);
        ModelAndView model = new ModelAndView("home-workspace.html");
        model.addObject("welcomeMessage", (Object)HTMLCleanupUtils.cleanHtml(welcomeMessage));
        model.addObject("userPrefs", (Object)userPrefs);
        model.addObject("canShowDashboard", (Object)canShowDashboard);
        model.addObject("shouldShowDashboard", (Object)shouldShowDashboard);
        List projects = this.projectFinder.findAllReadable();
        List projectsIds = IdentifiedUtil.extractIds((Collection)projects);
        List visibleBugtrackers = this.bugtrackerService.findDistinctBugTrackersForProjects(projectsIds);
        model.addObject("visibleBugtrackers", (Object)visibleBugtrackers);
        model.addObject("defaultInfoLists", (Object)this.i18nLevelEnumInfolistHelper.getInternationalizedDefaultList(locale));
        model.addObject("testCaseImportance", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseImportance.class, locale));
        model.addObject("testCaseStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseStatus.class, locale));
        model.addObject("requirementStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementStatus.class, locale));
        model.addObject("requirementCriticality", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementCriticality.class, locale));
        model.addObject("executionStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(ExecutionStatus.class, locale));
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        model.addObject("userLicenseInformation", (Object)userLicenseInformation);
        model.addObject("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return model;
    }

    @ResponseBody
    @RequestMapping(value={"/home-workspace/choose-message"}, method={RequestMethod.POST})
    public void chooseWelcomeMessageAsHomeContent() {
        this.partyPreferenceService.chooseWelcomeMessageAsHomeContentForCurrentUser();
    }

    @ResponseBody
    @RequestMapping(value={"/home-workspace/choose-dashboard"}, method={RequestMethod.POST})
    public void chooseFavoriteDashboardAsHomeContent() {
        this.partyPreferenceService.chooseFavoriteDashboardAsHomeContentForCurrentUser();
    }

    @ResponseBody
    @RequestMapping(value={"/administration/modify-welcome-message"}, method={RequestMethod.POST})
    public String modifyWelcomeMessage(@RequestParam(value="value") String welcomeMessage) {
        this.administrationService.modifyWelcomeMessage(welcomeMessage);
        return HTMLCleanupUtils.cleanHtml(welcomeMessage);
    }

    @ResponseBody
    @RequestMapping(value={"/administration/modify-login-message"}, method={RequestMethod.POST})
    public String modifyLoginMessage(@RequestParam(value="value") String loginMessage) {
        this.administrationService.modifyLoginMessage(loginMessage);
        return HTMLCleanupUtils.cleanHtml(loginMessage);
    }

    @RequestMapping(value={"/administration/welcome-message"})
    public ModelAndView welcomeMessagePage() {
        String welcomeMessage = this.administrationService.findWelcomeMessage();
        ModelAndView mav = new ModelAndView("page/administration/welcome-message-workspace");
        mav.addObject("welcomeMessage", (Object)welcomeMessage);
        return mav;
    }

    @RequestMapping(value={"/administration/login-message"})
    public ModelAndView loginMessagePage() {
        String loginMessage = this.administrationService.findLoginMessage();
        ModelAndView mav = new ModelAndView("page/administration/login-message-workspace");
        mav.addObject("loginMessage", (Object)loginMessage);
        return mav;
    }
}

