/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.users;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.service.user.AdministrationService;
import org.squashtest.tm.service.user.AuthenticatedUser;
import org.squashtest.tm.service.user.TeamFinderService;
import org.squashtest.tm.web.internal.controller.users.TeamModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/users"})
public class UserController {
    private static final String USER_ID = "userId";
    @Inject
    private AdministrationService service;
    @Inject
    private TeamFinderService teamFinder;
    private static final String USER_ID_URL = "/{userId}";
    private static final String STATUS = "status";
    private DatatableMapper<String> teamsMapper = new NameBasedMapper(1).map("team-name", "name");
    private static final Logger LOGGER = LoggerFactory.getLogger(UserController.class);

    @RequestMapping(value={"/{userId}/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable(value="userId") long userId) {
        AuthenticatedUser user = this.service.findUserById(userId);
        return new JsonGeneralInfo((AuditableMixin)user);
    }

    @RequestMapping(value={"/{userId}/teams"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTeamsTableModel(DataTableDrawParameters params, @PathVariable(value="userId") long userId) {
        LOGGER.info("Find associated teams table model for user #{}", (Object)userId);
        DataTableSorting paging = new DataTableSorting(params, this.teamsMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        return this.getTeamsTableModel(userId, paging, filtering, params.getsEcho());
    }

    @RequestMapping(value={"/{userId}/teams/{teamIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deassociateTeams(@PathVariable(value="userId") long userId, @PathVariable(value="teamIds") List<Long> teamIds) {
        LOGGER.info("Remove the user #{} from the given teams members.", (Object)userId);
        this.service.deassociateTeams(userId, teamIds);
    }

    @RequestMapping(value={"/{userId}/non-associated-teams"}, headers={"Accept=application/json"})
    @ResponseBody
    public Map<String, Object> getNonAssociatedTeams(@PathVariable(value="userId") long userId) {
        LOGGER.info("Find teams where user #{} is not a member.", (Object)userId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        long teamTot = this.teamFinder.countAll();
        if (teamTot <= 0L) {
            result.put(STATUS, "no-team");
        } else {
            List nonAssociatedTeams = this.service.findAllNonAssociatedTeams(userId);
            if (nonAssociatedTeams.isEmpty()) {
                result.put(STATUS, "no-more-teams");
            } else {
                result.put(STATUS, "ok");
                result.put("teams", CollectionUtils.collect((Collection)nonAssociatedTeams, (Transformer)new TeamModelCreator()));
            }
        }
        return result;
    }

    @RequestMapping(value={"/{userId}/teams/{ids}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void associateToTeams(@PathVariable(value="userId") long userId, @PathVariable(value="ids") List<Long> teamIds) {
        LOGGER.info("Add user #{} to given teams members.", (Object)userId);
        this.service.associateToTeams(userId, teamIds);
    }

    private DataTableModel getTeamsTableModel(long userId, PagingAndSorting paging, Filtering filtering, String secho) {
        PagedCollectionHolder holder = this.service.findSortedAssociatedTeams(userId, paging, filtering);
        return new TeamsTableModelHelper().buildDataModel(holder, secho);
    }

    private static final class TeamModelCreator
    implements Transformer {
        private TeamModelCreator() {
        }

        public Object transform(Object team) {
            return new TeamModel((Team)team);
        }
    }

    private static final class TeamsTableModelHelper
    extends DataTableModelBuilder<Team> {
        private TeamsTableModelHelper() {
        }

        protected Map<?, ?> buildItemData(Team item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("team-id", item.getId());
            res.put("team-index", this.getCurrentIndex());
            res.put("team-name", HtmlUtils.htmlEscape((String)item.getName()));
            res.put("empty-delete-holder", null);
            return res;
        }
    }
}

