/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.users;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.bugtracker.CannotConnectBugtrackerException;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.internal.servers.ManageableBasicAuthCredentials;
import org.squashtest.tm.service.internal.servers.UserOAuth1aToken;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerModificationController;
import org.squashtest.tm.web.internal.controller.users.PasswordChangeForm;

@Controller
@RequestMapping(value={"/user-account"})
public class UserAccountController {
    private static final String SQUASH_BUGTRACKER_MODE = "squash.bug.tracker.mode";
    private UserAccountService userService;
    @Inject
    private MilestoneManagerService milestoneManager;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    private ProjectsPermissionFinder permissionFinder;
    @Inject
    private AuthenticationProviderContext authenticationProviderContext;
    @Inject
    private PartyPreferenceService partyPreferenceService;
    @Inject
    private StoredCredentialsManager credManager;
    @Inject
    private UserAccountService userAccountService;
    private static final String BUGTRACKER_ID = "bugtrackerId";
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerModificationController.class);

    @Inject
    public void setProjectsPermissionFinderService(ProjectsPermissionFinder permissionFinder) {
        this.permissionFinder = permissionFinder;
    }

    @Inject
    public void setUserAccountService(UserAccountService service) {
        this.userService = service;
    }

    public PartyPreferenceService getPartyPreferenceService() {
        return this.partyPreferenceService;
    }

    public void setPartyPreferenceService(PartyPreferenceService partyPreferenceService) {
        this.partyPreferenceService = partyPreferenceService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getUserAccountDetails() {
        User user = this.userService.findCurrentUser();
        Long idUser = user.getId();
        Party party = this.userService.getParty(idUser);
        Map map = this.partyPreferenceService.findPreferences(party);
        String bugtrackerMode = (String)map.get(SQUASH_BUGTRACKER_MODE);
        boolean hasLocalPassword = this.userService.hasCurrentUserPasswordDefined();
        Map<BugTracker, ManageableCredentials> bugtrackerMap = this.getPairedBugtrackerAndManagedCredentials();
        Map<Long, String> asterikedPasswordMap = this.retrieveAsteriskedPasswordMap(bugtrackerMap);
        List milestoneList = this.milestoneManager.findAllVisibleToCurrentUser();
        List projectPermissions = this.permissionFinder.findProjectPermissionByUserLogin(user.getLogin());
        Collections.sort(milestoneList, new SortMilestoneList());
        ModelAndView mav = new ModelAndView("page/users/user-account");
        mav.addObject("user", (Object)user);
        mav.addObject("milestoneList", (Object)milestoneList);
        mav.addObject("projectPermissions", (Object)projectPermissions);
        mav.addObject("bugtrackerMode", (Object)bugtrackerMode);
        mav.addObject("hasLocalPassword", (Object)hasLocalPassword);
        mav.addObject("bugtrackerCredentialsMap", bugtrackerMap);
        mav.addObject("asterikedPasswordMap", asterikedPasswordMap);
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            JsonMilestone jsMilestone = new JsonMilestone(((Milestone)activeMilestone.get()).getId().longValue(), HtmlUtils.htmlEscape((String)((Milestone)activeMilestone.get()).getLabel()), ((Milestone)activeMilestone.get()).getStatus(), ((Milestone)activeMilestone.get()).getRange(), ((Milestone)activeMilestone.get()).getEndDate(), HtmlUtils.htmlEscape((String)((Milestone)activeMilestone.get()).getOwner().getLogin()));
            mav.addObject("activeMilestone", (Object)jsMilestone);
        }
        boolean canManageLocalPassword = this.authenticationProviderContext.isInternalProviderEnabled();
        mav.addObject("canManageLocalPassword", (Object)canManageLocalPassword);
        return mav;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, params={"initializing", "oldPassword", "newPassword"})
    @ResponseBody
    public void changePassword(@ModelAttribute @Valid PasswordChangeForm form) {
        if (form.isInitializing()) {
            this.userService.setCurrentUserPassword(form.getNewPassword());
        } else {
            this.userService.setCurrentUserPassword(form.getOldPassword(), form.getNewPassword());
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, params={"id=user-account-email", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String updateUserEmail(@RequestParam(value="value") String email) {
        this.userService.setCurrentUserEmail(email);
        return HtmlUtils.htmlEscape((String)email);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public PartyPreference changeUserBugtrackerMode(@RequestParam(value="value") String bugtrackerMode) {
        this.partyPreferenceService.addOrUpdatePreferenceForCurrentUser(SQUASH_BUGTRACKER_MODE, bugtrackerMode);
        return this.partyPreferenceService.findPreferenceForCurrentUser(SQUASH_BUGTRACKER_MODE);
    }

    private Map<BugTracker, ManageableCredentials> getPairedBugtrackerAndManagedCredentials() {
        LinkedHashMap<BugTracker, ManageableCredentials> bugtrackerMap = new LinkedHashMap<BugTracker, ManageableCredentials>();
        List bugtrackers = this.userService.findAllUserBugTracker();
        bugtrackers.sort(Comparator.comparing(ThirdPartyServer::getAuthenticationProtocol));
        for (BugTracker bugtracker : bugtrackers) {
            ManageableCredentials credentials = this.credManager.findCurrentUserCredentials(bugtracker.getId().longValue());
            if (credentials == null) {
                credentials = this.createDefaultCredentials(bugtracker);
            }
            bugtrackerMap.put(bugtracker, credentials);
        }
        return bugtrackerMap;
    }

    private ManageableCredentials createDefaultCredentials(BugTracker bugtracker) {
        ManageableBasicAuthCredentials credentials;
        switch (bugtracker.getAuthenticationProtocol()) {
            case BASIC_AUTH: {
                credentials = new ManageableBasicAuthCredentials("", "");
                break;
            }
            case OAUTH_1A: {
                credentials = new UserOAuth1aToken("", "");
                break;
            }
            default: {
                throw new IllegalArgumentException("AuthenticationProtocol '" + bugtracker.getAuthenticationProtocol() + "' not supported");
            }
        }
        return credentials;
    }

    @RequestMapping(value={"bugtracker/{bugtrackerId}/credentials"}, params={"username", "password"}, method={RequestMethod.POST})
    @ResponseBody
    public void saveCurrentUserCredentials(@PathVariable(value="bugtrackerId") long bugtrackerId, @RequestParam String username, @RequestParam char[] password) {
        ManageableBasicAuthCredentials credentials = new ManageableBasicAuthCredentials(username, password);
        try {
            this.userAccountService.testCurrentUserCredentials(bugtrackerId, (ManageableCredentials)credentials);
            this.userAccountService.saveCurrentUserCredentials(bugtrackerId, (ManageableCredentials)credentials);
        }
        catch (BugTrackerRemoteException ex) {
            LOGGER.debug("server-app credentials test failed : ", (Throwable)ex);
            throw new CannotConnectBugtrackerException((Exception)((Object)ex));
        }
    }

    @RequestMapping(value={"bugtracker/{bugtrackerId}/credentials/validator"}, params={"username", "password"}, method={RequestMethod.POST})
    @ResponseBody
    public void testCredentials(@PathVariable(value="bugtrackerId") long bugtrackerId, @RequestParam String username, @RequestParam char[] password) {
        ManageableBasicAuthCredentials credentials = new ManageableBasicAuthCredentials(username, password);
        try {
            this.userAccountService.testCurrentUserCredentials(bugtrackerId, (ManageableCredentials)credentials);
        }
        catch (BugTrackerRemoteException ex) {
            LOGGER.debug("server-app credentials test failed : ", (Throwable)ex);
            throw new CannotConnectBugtrackerException((Exception)((Object)ex));
        }
    }

    @RequestMapping(value={"bugtracker/{bugtrackerId}/credentials/validator"}, method={RequestMethod.POST})
    @ResponseBody
    public void testCredentials(@PathVariable(value="bugtrackerId") long bugtrackerId) {
        ManageableCredentials credentials = this.credManager.findCurrentUserCredentials(bugtrackerId);
        try {
            this.userAccountService.testCurrentUserCredentials(bugtrackerId, credentials);
        }
        catch (BugTrackerRemoteException ex) {
            LOGGER.debug("server-app credentials test failed for current user with orig credentials : ", (Throwable)ex);
            throw new CannotConnectBugtrackerException((Exception)((Object)ex));
        }
    }

    @RequestMapping(value={"bugtracker/{bugtrackerId}/credentials"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteUserCredentials(@PathVariable(value="bugtrackerId") long bugtrackerId) {
        this.userAccountService.deleteCurrentUserCredentials(bugtrackerId);
    }

    private Map<Long, String> retrieveAsteriskedPasswordMap(Map<BugTracker, ManageableCredentials> bugTrackerMap) {
        return bugTrackerMap.entrySet().stream().collect(Collectors.toMap(b -> ((BugTracker)b.getKey()).getId(), c -> BugTrackerControllerHelper.retrieveAsteriskedPassword(((ManageableCredentials)c.getValue()).getImplementedProtocol(), (ManageableCredentials)c.getValue())));
    }

    public class SortMilestoneList
    implements Comparator<Milestone> {
        @Override
        public int compare(Milestone m1, Milestone m2) {
            return m1.getLabel().compareTo(m2.getLabel());
        }
    }
}

