/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.users;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.DefaultFiltering;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.web.internal.controller.administration.UserModel;
import org.squashtest.tm.web.internal.controller.project.ProjectModel;
import org.squashtest.tm.web.internal.controller.users.PartyControllerSupport;
import org.squashtest.tm.web.internal.controller.users.PermissionGroupModel;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/administration/teams"})
public class TeamController
extends PartyControllerSupport {
    private static final String TEAM_ID = "teamId";
    private static final String TEAM_ID_URL = "/{teamId}";
    private static final String DESCRIPTION = "description";
    @Inject
    private TeamModificationService service;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ConfigurationService configurationService;
    private DatatableMapper<String> teamsMapper = new NameBasedMapper(9).mapAttribute("name", "name", Team.class).mapAttribute("description", "description", Team.class).mapAttribute("nb-associated-users", "members.size", Team.class).mapAttribute("created-on", "audit.createdOn", Team.class).mapAttribute("created-by", "audit.createdBy", Team.class).mapAttribute("last-mod-on", "audit.lastModifiedOn", Team.class).mapAttribute("last-mod-by", "audit.lastModifiedBy", Team.class);
    private DatatableMapper<String> membersMapper = new NameBasedMapper(1).map("user-name", "firstName");
    private DatatableMapper<String> permissionMapper = new NameBasedMapper(2).mapAttribute("project-name", "project.name", ProjectPermission.class).mapAttribute("permission-name", "permissionGroup.qualifiedName", ProjectPermission.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamController.class);

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void createNew(@Valid @ModelAttribute(value="add-team") Team team) {
        LOGGER.info(ToStringBuilder.reflectionToString((Object)team));
        this.service.persist(team);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTableModel(DataTableDrawParameters params, Locale locale) {
        DataTableSorting paging = new DataTableSorting(params, this.teamsMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        PagedCollectionHolder holder = this.service.findAllFiltered((PagingAndSorting)paging, (Filtering)filtering);
        return new TeamsDataTableModelHelper(locale, this.messageSource).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/{teamId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteTeam(@PathVariable List<Long> teamId) {
        this.service.deleteTeam(teamId);
    }

    @RequestMapping(value={"/{teamId}"}, method={RequestMethod.GET})
    public String showTeamModificationPage(@PathVariable Long teamId, Model model) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            throw new AccessDeniedException("Access is denied");
        }
        Team team = this.service.findById(teamId);
        List permissionModel = this.createPermissionTableModel(teamId, (PagingAndSorting)new DefaultPagingAndSorting(), (Filtering)DefaultFiltering.NO_FILTERING, "").getAaData();
        List userModel = this.createMembersTableModel(teamId, (PagingAndSorting)new DefaultPagingAndSorting(), (Filtering)DefaultFiltering.NO_FILTERING, "").getAaData();
        List<PermissionGroupModel> pgm = this.getPermissionGroupModels();
        pgm.sort(Comparator.comparing(PermissionGroupModel::getDisplayName));
        List<ProjectModel> pm = this.getProjectModels(teamId);
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        model.addAttribute("team", (Object)team);
        model.addAttribute("users", userModel);
        model.addAttribute("permissionList", pgm);
        model.addAttribute("myprojectList", pm);
        model.addAttribute("permissions", permissionModel);
        model.addAttribute("userLicenseInformationData", (Object)userLicenseInformation);
        return "team-modification.html";
    }

    @RequestMapping(value={"/{teamId}"}, method={RequestMethod.POST}, params={"id=team-description"})
    @ResponseBody
    public String changeDescription(@PathVariable Long teamId, @RequestParam String value) {
        this.service.changeDescription(teamId.longValue(), value);
        return value;
    }

    @RequestMapping(value={"/{teamId}/name"}, method={RequestMethod.POST})
    @ResponseBody
    public RenameModel changeName(@PathVariable Long teamId, @RequestParam String value) {
        this.service.changeName(teamId.longValue(), value);
        return new RenameModel(value);
    }

    @RequestMapping(value={"/{teamId}/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable(value="teamId") long teamId) {
        Team team = this.service.findById(Long.valueOf(teamId));
        return new JsonGeneralInfo((AuditableMixin)team);
    }

    @RequestMapping(value={"/{teamId}/members"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getMembersTableModel(DataTableDrawParameters params, @PathVariable(value="teamId") long teamId) {
        DataTableSorting paging = new DataTableSorting(params, this.membersMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        return this.createMembersTableModel(teamId, paging, filtering, params.getsEcho());
    }

    @RequestMapping(value={"/{teamId}/members/{memberIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeMember(@PathVariable(value="teamId") long teamId, @PathVariable(value="memberIds") List<Long> memberIds) {
        this.service.removeMembers(teamId, memberIds);
    }

    @RequestMapping(value={"/{teamId}/non-members"}, headers={"Accept=application/json"})
    @ResponseBody
    public Collection<UserModel> getNonMembers(@PathVariable(value="teamId") long teamId) {
        List nonMembers = this.service.findAllNonMemberUsers(teamId);
        return CollectionUtils.collect((Collection)nonMembers, (Transformer)new UserModelCreator());
    }

    @RequestMapping(value={"/{teamId}/members/{logins}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void addMembers(@PathVariable(value="teamId") long teamId, @PathVariable(value="logins") List<String> userlogins) {
        this.service.addMembers(teamId, userlogins);
    }

    @RequestMapping(value={"/{teamId}/add-permission"}, method={RequestMethod.POST})
    @ResponseBody
    public void addNewPermission(@RequestParam(value="project") long projectId, @PathVariable long teamId, @RequestParam String permission) {
        this.permissionService.addNewPermissionToProject(teamId, projectId, permission);
    }

    @RequestMapping(value={"/{teamId}/remove-permission"}, method={RequestMethod.POST})
    @ResponseBody
    public void removePermission(@RequestParam(value="project") long projectId, @PathVariable long teamId) {
        this.permissionService.removeProjectPermission(teamId, projectId);
    }

    @RequestMapping(value={"/{teamId}/permissions"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getPermissionTableModel(DataTableDrawParameters params, @PathVariable(value="teamId") long teamId) {
        DataTableSorting paging = new DataTableSorting(params, this.permissionMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        return this.createPermissionTableModel(teamId, paging, filtering, params.getsEcho());
    }

    private DataTableModel createMembersTableModel(long teamId, PagingAndSorting paging, Filtering filtering, String secho) {
        PagedCollectionHolder holder = this.service.findAllTeamMembers(teamId, paging, filtering);
        return new MembersTableModelHelper().buildDataModel(holder, secho);
    }

    @RequestMapping(value={"/{teamId}/permission-popup"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getPermissionPopup(@PathVariable long teamId) {
        return this.createPermissionPopupModel(teamId);
    }

    private static final class MembersTableModelHelper
    extends DataTableModelBuilder<User> {
        private MembersTableModelHelper() {
        }

        protected Map<?, ?> buildItemData(User item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("user-id", item.getId());
            res.put("user-active", item.getActive());
            res.put("user-index", this.getCurrentIndex());
            res.put("user-name", String.valueOf(HtmlUtils.htmlEscape((String)item.getFirstName())) + " " + HtmlUtils.htmlEscape((String)item.getLastName()) + " (" + HtmlUtils.htmlEscape((String)item.getLogin()) + ")");
            res.put("empty-delete-holder", null);
            return res;
        }
    }

    private static final class TeamsDataTableModelHelper
    extends DataTableModelBuilder<Team> {
        private InternationalizationHelper messageSource;
        private Locale locale;

        private TeamsDataTableModelHelper(Locale locale, InternationalizationHelper messageSource) {
            this.locale = locale;
            this.messageSource = messageSource;
        }

        public Map<String, Object> buildItemData(Team item) {
            Team auditable = item;
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("entity-id", item.getId());
            res.put("entity-index", this.getCurrentIndex());
            res.put("name", HtmlUtils.htmlEscape((String)item.getName()));
            res.put(TeamController.DESCRIPTION, HTMLCleanupUtils.escapeOrDefault(item.getDescription(), ""));
            res.put("nb-associated-users", item.getMembers().size());
            res.put("created-on", this.messageSource.localizeDate(auditable.getCreatedOn(), this.locale));
            res.put("created-by", HtmlUtils.htmlEscape((String)auditable.getCreatedBy()));
            res.put("last-mod-on", this.messageSource.localizeDate(auditable.getLastModifiedOn(), this.locale));
            res.put("last-mod-by", HTMLCleanupUtils.escapeOrDefault(auditable.getLastModifiedBy(), null));
            res.put("empty-delete-holder", " ");
            return res;
        }
    }

    private static final class UserModelCreator
    implements Transformer {
        private UserModelCreator() {
        }

        public Object transform(Object user) {
            return new UserModel((User)user);
        }
    }
}

