/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.users;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Sort;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.security.acls.PermissionGroup;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.web.internal.controller.project.ProjectModel;
import org.squashtest.tm.web.internal.controller.users.PermissionGroupModel;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public abstract class PartyControllerSupport {
    protected ProjectsPermissionManagementService permissionService;
    @Inject
    protected InternationalizationHelper messageSource;

    @Inject
    public void setProjectsPermissionManagementService(ProjectsPermissionManagementService permissionService) {
        this.permissionService = permissionService;
    }

    protected List<PermissionGroupModel> getPermissionGroupModels() {
        Locale locale = LocaleContextHolder.getLocale();
        List permissionList = this.permissionService.findAllPossiblePermission();
        ArrayList<PermissionGroupModel> permissionGroupModelList = new ArrayList<PermissionGroupModel>();
        if (permissionList != null) {
            for (PermissionGroup permission : permissionList) {
                PermissionGroupModel model = new PermissionGroupModel(permission);
                model.setDisplayName(this.messageSource.getMessage("user.project-rights." + model.getSimpleName() + ".label", null, locale));
                permissionGroupModelList.add(model);
            }
        }
        return permissionGroupModelList;
    }

    protected List<ProjectModel> getProjectModels(long partyId) {
        List projectList = this.permissionService.findProjectWithoutPermissionByParty(partyId, new Sort(Sort.Direction.ASC, new String[]{"name"}));
        ArrayList<ProjectModel> projectModelList = new ArrayList<ProjectModel>();
        if (projectList != null) {
            for (GenericProject project : projectList) {
                projectModelList.add(new ProjectModel(project));
            }
        }
        return projectModelList;
    }

    protected Map<String, Object> createPermissionPopupModel(long partyId) {
        List<ProjectModel> projectModelList = this.getProjectModels(partyId);
        List<PermissionGroupModel> permissionGroupModelList = this.getPermissionGroupModels();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("myprojectList", projectModelList);
        res.put("permissionList", permissionGroupModelList);
        return res;
    }

    protected DataTableModel createPermissionTableModel(long userId, PagingAndSorting paging, Filtering filtering, String secho) {
        Locale locale = LocaleContextHolder.getLocale();
        PagedCollectionHolder holder = this.permissionService.findProjectPermissionByParty(userId, paging, filtering);
        return new PermissionTableModelHelper(locale, this.messageSource).buildDataModel(holder, secho);
    }

    protected static final class PermissionTableModelHelper
    extends DataTableModelBuilder<ProjectPermission> {
        private MessageSource messageSource;
        private Locale locale;

        private PermissionTableModelHelper(Locale locale, MessageSource messageSource) {
            this.locale = locale;
            this.messageSource = messageSource;
        }

        public Map<String, Object> buildItemData(ProjectPermission item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("project-id", item.getProject().getId());
            res.put("project-index", this.getCurrentIndex());
            res.put("project-name", HtmlUtils.htmlEscape((String)item.getProject().getName()));
            res.put("permission-id", item.getPermissionGroup().getId());
            res.put("permission-name", HtmlUtils.htmlEscape((String)item.getPermissionGroup().getQualifiedName()));
            res.put("permission-simplename", HtmlUtils.htmlEscape((String)item.getPermissionGroup().getSimpleName()));
            res.put("permission-displayname", this.messageSource.getMessage("user.project-rights." + item.getPermissionGroup().getSimpleName() + ".label", null, this.locale));
            res.put("empty-delete-holder", null);
            res.put("empty-permission-list-holder", null);
            return res;
        }
    }
}

