/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.thirdpartyserver;

import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.servers.EncryptionKeyChangedException;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.MissingEncryptionKeyException;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementBean;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Component
public class ThirdPartyServerCredentialsManagementHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyServerCredentialsManagementHelper.class);
    @Inject
    private StoredCredentialsManager credentialsManager;
    @Inject
    private InternationalizationHelper i18nHelper;

    public ThirdPartyServerCredentialsManagementBean initializeFor(ThirdPartyServer server, Locale locale) {
        ThirdPartyServerCredentialsManagementBean bean = new ThirdPartyServerCredentialsManagementBean();
        bean.setRemoteUrl(server.getUrl());
        bean.setAuthPolicy(server.getAuthenticationPolicy());
        bean.setSelectedProto(server.getAuthenticationProtocol());
        try {
            ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(server.getId().longValue());
            ServerAuthConfiguration configuration = this.credentialsManager.findServerAuthConfiguration(server.getId().longValue());
            bean.setCredentials(credentials);
            bean.setAuthConf(configuration);
        }
        catch (MissingEncryptionKeyException ex) {
            String msg = this.i18nHelper.internationalize((Internationalizable)ex, locale);
            bean.setFailureMessage(msg);
        }
        catch (EncryptionKeyChangedException ex) {
            String msg = this.i18nHelper.internationalize((Internationalizable)ex, locale);
            bean.setWarningMessage(msg);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            bean.setWarningMessage(ex.getMessage());
        }
        return bean;
    }
}

