/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.tf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedTestTechnologyFinderService;
import org.squashtest.tm.service.tf.AutomationRequestFinderService;
import org.squashtest.tm.web.internal.controller.tf.AutomationRequestDataTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/automation-workspace"})
public class AutomationWorkspaceController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutomationWorkspaceController.class);
    @Inject
    private AutomationRequestFinderService automationRequestFinderService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private AutomatedTestTechnologyFinderService automatedTestTechnologyFinderService;
    @Inject
    private ScmRepositoryManagerService scmRepositoryManagerService;
    private final DatatableMapper<String> automationRequestMapper = new NameBasedMapper().map("project-name", "testCase.project.name").map("reference", "testCase.reference").map("name", "testCase.name").map("format", "testCase.kind").map("entity-id", "testCase.id").map("created-by", "testCase.audit.lastModifiedBy").map("transmitted-on", "transmissionDate").map("priority", "automationPriority").map("status", "requestStatus").map("conflictAssociation", "testCase.automationRequest.conflictAssociation").map("assigned-on", "assignmentDate").map("script", "testCase.automatedTest.name").map("entity-index", "index(AutomationRequest)").map("requestId", "id").map("assigned-to", "assignedTo.login").map("uuid", "testCase.uuid").map("listScriptConflict", "testCase.automationRequest.conflictAssociation").map("scm-url", "testCase.scmRepository.scmServer.url").map("automated-test-reference", "testCase.automatedTestReference").map("automated-test-technology", "testCase.automatedTestTechnology");

    @RequestMapping(method={RequestMethod.GET})
    public String showWorkspace(Model model, Locale locale) {
        Map automReqStatuses = Stream.of(AutomationRequestStatus.values()).collect(Collectors.toMap(Enum::name, e -> this.messageSource.internationalize(e.getI18nKey(), locale), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        ArrayList automReqStatusList = new ArrayList(automReqStatuses.keySet());
        Map assignableUsers = this.automationRequestFinderService.getTcLastModifiedByForCurrentUser(automReqStatusList);
        Map globalUsers = this.automationRequestFinderService.getTcLastModifiedByForAutomationRequests(automReqStatusList);
        Map traitmentUsers = this.automationRequestFinderService.getTcLastModifiedByToAutomationRequestNotAssigned(Arrays.asList(AutomationRequestStatus.TRANSMITTED.name(), AutomationRequestStatus.AUTOMATION_IN_PROGRESS.name()));
        Map assignableUsersGlobalView = this.automationRequestFinderService.getAssignedToForAutomationRequests();
        model.addAttribute("assignableUsers", (Object)assignableUsers);
        model.addAttribute("traitmentUsers", (Object)traitmentUsers);
        model.addAttribute("globalUsers", (Object)globalUsers);
        model.addAttribute("assignableUsersGlobalView", (Object)assignableUsersGlobalView);
        Map<String, String> tcKinds = Arrays.stream(TestCaseKind.values()).collect(Collectors.toMap(Enum::toString, e -> this.messageSource.internationalize(e.getI18nKey(), locale)));
        model.addAttribute("tcKinds", tcKinds);
        Map<String, String> autoReqStatusesTraitment = Stream.of(AutomationRequestStatus.TRANSMITTED, AutomationRequestStatus.AUTOMATION_IN_PROGRESS).collect(Collectors.toMap(Enum::toString, e -> this.messageSource.internationalize(e.getI18nKey(), locale)));
        model.addAttribute("autoReqStatusesTraitment", autoReqStatusesTraitment);
        model.addAttribute("autoReqStatuses", (Object)automReqStatuses);
        List automatedTestTechnologies = this.automatedTestTechnologyFinderService.getAllAvailableAutomatedTestTechnology();
        model.addAttribute("automatedTestTechnologies", (Object)automatedTestTechnologies);
        List scmRepositoryList = this.scmRepositoryManagerService.getAllDeclaredScmRepositories(locale);
        model.addAttribute("scmRepositoryList", (Object)scmRepositoryList);
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        model.addAttribute("userLicenseInformation", (Object)userLicenseInformation);
        model.addAttribute("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return this.getWorkspaceViewName();
    }

    protected String getWorkspaceViewName() {
        return "automation-workspace.html";
    }

    protected WorkspaceType getWorkspaceType() {
        return WorkspaceType.AUTOMATION_WORKSPACE;
    }

    @RequestMapping(value={"automation-requests"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getAutomationRequestModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.automationRequestMapper);
        DataTableColumnFiltering filtering = new DataTableColumnFiltering(params, this.automationRequestMapper);
        Page automationRequestPage = this.automationRequestFinderService.findRequestsAssignedToCurrentUser(pageable, (ColumnFiltering)filtering);
        return new AutomationRequestDataTableModelHelper(this.messageSource, this.permissionEvaluationService).buildDataModel(automationRequestPage, "");
    }

    @RequestMapping(value={"automation-requests/traitment"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getAutomationRequestTraitmentModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.automationRequestMapper);
        DataTableColumnFiltering filtering = new DataTableColumnFiltering(params, this.automationRequestMapper);
        Page automationRequestPage = this.automationRequestFinderService.findRequestsWithTransmittedStatus(pageable, (ColumnFiltering)filtering);
        return new AutomationRequestDataTableModelHelper(this.messageSource, this.permissionEvaluationService).buildDataModel(automationRequestPage, "");
    }

    @RequestMapping(value={"automation-requests/global"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getAutomationRequestGlobalModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.automationRequestMapper);
        DataTableColumnFiltering filtering = new DataTableColumnFiltering(params, this.automationRequestMapper);
        Page automationRequestPage = this.automationRequestFinderService.findRequestsForGlobal(pageable, (ColumnFiltering)filtering);
        return new AutomationRequestDataTableModelHelper(this.messageSource, this.permissionEvaluationService).buildDataModel(automationRequestPage, "");
    }

    @RequestMapping(value={"count"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer countAutomationRequestToCurrentUser() {
        return this.automationRequestFinderService.countAutomationRequestForCurrentUser();
    }

    @RequestMapping(value={"assigned/testers/{statuses}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getTestersForCurrentUser(@PathVariable List<String> statuses) {
        return this.automationRequestFinderService.getTcLastModifiedByForCurrentUser(statuses);
    }

    @RequestMapping(value={"global/testers/{statuses}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getTesters(@PathVariable List<String> statuses) {
        return this.automationRequestFinderService.getTcLastModifiedByForAutomationRequests(statuses);
    }

    @RequestMapping(value={"traitment/testers/{statuses}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getTestersForTraitment(@PathVariable List<String> statuses) {
        return this.automationRequestFinderService.getTcLastModifiedByToAutomationRequestNotAssigned(statuses);
    }

    @RequestMapping(value={"assignee"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getAssignee() {
        return this.automationRequestFinderService.getAssignedToForAutomationRequests();
    }
}

