/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.tf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.tf.AutomationRequestFinderService;
import org.squashtest.tm.web.internal.controller.tf.AutomationRequestDataTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/automation-tester-workspace"})
public class AutomationTesterWorkspaceController {
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private AutomationRequestFinderService automationRequestFinderService;
    @Inject
    private ConfigurationService configurationService;
    private final DatatableMapper<String> automationRequestMapper = new NameBasedMapper().map("project-name", "testCase.project.name").map("reference", "testCase.reference").map("name", "testCase.name").map("format", "testCase.kind").map("entity-id", "testCase.id").map("created-by", "testCase.audit.lastModifiedBy").map("transmitted-on", "transmissionDate").map("priority", "automationPriority").map("status", "requestStatus").map("assigned-on", "assignmentDate").map("script", "testCase.automatedTest.name").map("entity-index", "index(AutomationRequest)").map("requestId", "id").map("assigned-to", "assignedTo").map("uuid", "testCase.uuid");

    @RequestMapping(method={RequestMethod.GET})
    public String showWorkspace(Model model, Locale locale) {
        Map automReqStatuses = Stream.of(AutomationRequestStatus.values()).collect(Collectors.toMap(Enum::name, e -> this.messageSource.internationalize(e.getI18nKey(), locale), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        Map<String, String> tcKinds = Arrays.stream(TestCaseKind.values()).collect(Collectors.toMap(Enum::toString, e -> this.messageSource.internationalize(e.getI18nKey(), locale)));
        Map automReqStatusesValidate = Stream.of(AutomationRequestStatus.SUSPENDED, AutomationRequestStatus.REJECTED, AutomationRequestStatus.WORK_IN_PROGRESS).collect(Collectors.toMap(Enum::toString, e -> this.messageSource.internationalize(e.getI18nKey(), locale), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        model.addAttribute("autoReqStatusesValidateView", (Object)automReqStatusesValidate);
        model.addAttribute("autoReqStatusesGlobalView", (Object)automReqStatuses);
        model.addAttribute("tcKinds", tcKinds);
        model.addAttribute("testerTransmitted", (Object)this.automationRequestFinderService.getTcLastModifiedByForAutomationRequests(Collections.singletonList(AutomationRequestStatus.READY_TO_TRANSMIT.name())));
        model.addAttribute("testerValidate", (Object)this.automationRequestFinderService.getTcLastModifiedByForAutomationRequests(Arrays.asList(AutomationRequestStatus.WORK_IN_PROGRESS.name(), AutomationRequestStatus.SUSPENDED.name(), AutomationRequestStatus.REJECTED.name())));
        ArrayList allStatus = new ArrayList(automReqStatuses.keySet());
        model.addAttribute("testerGlobalView", (Object)this.automationRequestFinderService.getTcLastModifiedByForAutomationRequests(allStatus));
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        model.addAttribute("userLicenseInformation", (Object)userLicenseInformation);
        model.addAttribute("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return this.getWorkspaceViewName();
    }

    protected String getWorkspaceViewName() {
        return "automation-tester-workspace.html";
    }

    protected WorkspaceType getWorkspaceType() {
        return WorkspaceType.AUTOMATION_TESTER_WORKSPACE;
    }

    @RequestMapping(value={"/automation-request/transmitted"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTransmittedModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.automationRequestMapper);
        DataTableColumnFiltering filtering = new DataTableColumnFiltering(params, this.automationRequestMapper);
        Page automationRequestPage = this.automationRequestFinderService.findRequestsToTransmitted(pageable, (ColumnFiltering)filtering);
        return new AutomationRequestDataTableModelHelper(this.messageSource, this.permissionEvaluationService).buildDataModel(automationRequestPage, "");
    }

    @RequestMapping(value={"/automation-request/validate"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getValidateModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.automationRequestMapper);
        DataTableColumnFiltering filtering = new DataTableColumnFiltering(params, this.automationRequestMapper);
        Page automationRequestPage = this.automationRequestFinderService.findRequestsToValidate(pageable, (ColumnFiltering)filtering);
        return new AutomationRequestDataTableModelHelper(this.messageSource, this.permissionEvaluationService).buildDataModel(automationRequestPage, "");
    }

    @RequestMapping(value={"/automation-request/global"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getAutomationRequestGlobalModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.automationRequestMapper);
        DataTableColumnFiltering filtering = new DataTableColumnFiltering(params, this.automationRequestMapper);
        Page automationRequestPage = this.automationRequestFinderService.findRequests(pageable, (ColumnFiltering)filtering);
        return new AutomationRequestDataTableModelHelper(this.messageSource, this.permissionEvaluationService).buildDataModel(automationRequestPage, "");
    }

    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer countAutomationRequestValid() {
        return this.automationRequestFinderService.countAutomationRequestValid();
    }

    @RequestMapping(value={"/lastModifiedBy/{reqStatuses}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getLastModifiedBy(@PathVariable List<String> reqStatuses) {
        return this.automationRequestFinderService.getTcLastModifiedByForAutomationRequests(reqStatuses);
    }
}

