/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.tf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

@Component
public class AutomationRequestDataTableModelHelper
extends DataTableModelBuilder<AutomationRequest> {
    private InternationalizationHelper messageSource;
    private Locale locale = LocaleContextHolder.getLocale();
    private PermissionEvaluationService permissionEvaluationService;
    private static final String NO_DATA = "-";

    public AutomationRequestDataTableModelHelper(InternationalizationHelper messageSource, PermissionEvaluationService permissionEvaluationService) {
        this.messageSource = messageSource;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    protected Object buildItemData(AutomationRequest item) {
        TestCase auditable = item.getTestCase();
        TestCase testCase = item.getTestCase();
        HashMap<String, Object> data = new HashMap<String, Object>(17);
        data.put("project-name", testCase != null ? HtmlUtils.htmlEscape((String)testCase.getProject().getName()) : null);
        data.put("reference", testCase != null && !testCase.getReference().isEmpty() ? testCase.getReference() : NO_DATA);
        data.put("name", testCase != null ? HtmlUtils.htmlEscape((String)testCase.getName()) : null);
        GetKindTestCaseVisitor visitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)visitor);
        data.put("format", testCase != null ? this.messageSource.internationalize(visitor.getKind().getI18nKey(), this.locale) : null);
        data.put("entity-id", testCase != null ? testCase.getId() : null);
        data.put("created-by", auditable.getLastModifiedBy());
        data.put("transmitted-on", this.messageSource.localizeShortDate(item.getTransmissionDate(), this.locale));
        data.put("priority", item.getAutomationPriority() != null ? item.getAutomationPriority() : null);
        data.put("assigned-on", this.messageSource.localizeShortDate(item.getAssignmentDate(), this.locale));
        data.put("entity-index", this.getCurrentIndex());
        data.put("script", this.populateScriptAuto(item));
        data.put("scm-url", testCase.getScmRepository() != null ? testCase.getScmRepository().getFriendlyUrl() : this.messageSource.internationalize("label.None", this.locale));
        data.put("automated-test-reference", testCase.getAutomatedTestReference());
        data.put("automated-test-technology", testCase.getAutomatedTestTechnology() == null ? null : testCase.getAutomatedTestTechnology().getName());
        data.put("uuid", testCase.getUuid());
        data.put("checkbox", "");
        data.put("tc-id", testCase != null ? testCase.getId() : null);
        data.put("requestId", item.getId());
        data.put("assigned-to", item.getAssignedTo() != null ? item.getAssignedTo().getLogin() : NO_DATA);
        data.put("status", this.messageSource.internationalize(item.getRequestStatus().getI18nKey(), this.locale));
        data.put("listScriptConflict", testCase != null && testCase.getAutomationRequest() != null ? this.convertChaineToList(testCase.getAutomationRequest().getConflictAssociation()) : null);
        data.put("writable", this.isWritable(testCase, true));
        data.put("writableAutom", this.isWritable(testCase, false));
        data.put("isManual", item.isManual());
        return data;
    }

    private List<String> convertChaineToList(String chaine) {
        String[] list = chaine.split("#");
        ArrayList<String> listScript = new ArrayList<String>(Arrays.asList(list));
        return listScript;
    }

    private String populateScriptAuto(AutomationRequest item) {
        TestCase testCase = item.getTestCase();
        if (item.getProject().hasTestAutomationProjects()) {
            if (this.hasScriptAuto(item)) {
                return testCase.getAutomatedTest().getFullLabel();
            }
            final Wrapped result = new Wrapped();
            TestCaseVisitor visitor = new TestCaseVisitor(){

                public void visit(TestCase testCase) {
                    result.setValue(null);
                }

                public void visit(KeywordTestCase keywordTestCase) {
                    result.setValue(null);
                }

                public void visit(ScriptedTestCase scriptedTestCase) {
                    result.setValue((Object)AutomationRequestDataTableModelHelper.NO_DATA);
                }
            };
            testCase.accept(visitor);
            return (String)result.getValue();
        }
        return NO_DATA;
    }

    private boolean isWritable(TestCase testCase, boolean isTester) {
        if (isTester && !this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)testCase)) {
            return false;
        }
        Set milestones = testCase.getAllMilestones();
        for (Milestone milestone : milestones) {
            if (!MilestoneStatus.LOCKED.equals((Object)milestone.getStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean hasScriptAuto(AutomationRequest item) {
        return item.getTestCase() != null && item.getTestCase().getAutomatedTest() != null && item.getProject().isTestAutomationEnabled();
    }
}

