/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.tf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import org.squashtest.tm.web.internal.model.testautomation.TATestNode;
import org.squashtest.tm.web.internal.model.testautomation.TATestNodeListBuilder;

@Controller
@RequestMapping(value={"/automation-requests"})
public class AutomationModificationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutomationModificationController.class);
    private static final String TEST_CASE_ID = "testCaseId";
    private static final String PATH = "path";
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private AutomationRequestModificationService automationRequestModificationService;

    @Inject
    public void setTestCaseModificationService(TestCaseModificationService testCaseModificationService) {
        this.testCaseModificationService = testCaseModificationService;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{tcIds}"}, params={"id=automation-request-status", "value"})
    @ResponseBody
    public void changeStatus(@PathVariable List<Long> tcIds, @RequestParam(value="value") AutomationRequestStatus status) {
        this.automationRequestModificationService.changeStatus(tcIds, status);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/unassigned"}, params={"tcIds[]"})
    public void unassignedUser(@RequestParam(value="tcIds[]") List<Long> tcIds) {
        this.automationRequestModificationService.unassignRequests(tcIds);
    }

    @RequestMapping(value={"{testCaseId}/tests"}, method={RequestMethod.POST}, params={"path"})
    @ResponseBody
    public String bindAutomatedTest(@PathVariable(value="testCaseId") long testCaseId, @RequestParam(value="path") String testPath) {
        this.testCaseModificationService.bindAutomatedTestByAutomationProgrammer(Long.valueOf(testCaseId), testPath);
        return testPath;
    }

    @RequestMapping(value={"{testCaseId}/tests"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<TATestNode> findAssignableAutomatedTests(@PathVariable(value="testCaseId") Long testCaseId) {
        Collection projectContents = this.testCaseModificationService.findAssignableAutomationTestsToAutomationProgramer(testCaseId.longValue());
        return new TATestNodeListBuilder().build(projectContents);
    }

    @RequestMapping(value={"/assignee"}, method={RequestMethod.POST}, params={"tcIds[]"})
    @ResponseBody
    public void assigneeToAutomationReq(@RequestParam(value="tcIds[]") List<Long> tcIds) {
        this.automationRequestModificationService.assignedToRequest(tcIds);
    }

    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"tcIds[]"})
    @ResponseBody
    public Map<Long, String> resolveTAScriptAssociation(@RequestParam(value="tcIds[]") List<Long> tcIds) {
        return this.automationRequestModificationService.updateTAScript(tcIds);
    }

    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"iterationId"}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> resolveTAScriptAssociationForIteration(@RequestParam(value="iterationId") long iterationId) {
        return this.automationRequestModificationService.updateTAScriptForIteration(Long.valueOf(iterationId));
    }

    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"testSuiteId", "!testPlanItemsIds[]"}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> resolveTAScriptAssociationForTestSuite(@RequestParam(value="testSuiteId") long testSuiteId) {
        return this.automationRequestModificationService.updateTAScriptForTestSuite(Long.valueOf(testSuiteId));
    }

    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"testPlanItemsIds[]", "iterationId"}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> resolveTAScriptAssociationForIterationItems(@RequestParam(value="testPlanItemsIds[]") List<Long> testPlanIds) {
        return this.automationRequestModificationService.updateTAScriptForItems(testPlanIds);
    }

    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST}, params={"testPlanItemsIds[]", "testSuiteId"}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> resolveTAScriptAssociationForTestSuiteItems(@RequestParam(value="testPlanItemsIds[]") List<Long> testPlanIds) {
        return this.automationRequestModificationService.updateTAScriptForItems(testPlanIds);
    }
}

