/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.MultiValuedCustomFieldValue;
import org.squashtest.tm.domain.customfield.NumericCustomFieldValue;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class TestStepsTableModelBuilder
extends DataTableModelBuilder<TestStep>
implements TestStepVisitor {
    private static final int DEFAULT_MAP_CAPACITY = 16;
    private static final String STEP_ID = "step-id";
    private Map<Long, Map<String, CustomFieldValueTableModel>> customFieldValuesById;
    private Map<?, ?> lastBuiltItem;

    protected Map<?, ?> buildItemData(TestStep item) {
        item.accept((TestStepVisitor)this);
        return this.lastBuiltItem;
    }

    public void visit(ActionTestStep visited) {
        HashMap<Object, Object> item = new HashMap<Object, Object>(11);
        item.put(STEP_ID, visited.getId());
        item.put("step-index", this.getCurrentIndex());
        item.put("attach-list-id", visited.getAttachmentList().getId());
        item.put("step-action", HTMLCleanupUtils.cleanHtml(visited.getAction()));
        item.put("step-result", HTMLCleanupUtils.cleanHtml(visited.getExpectedResult()));
        item.put("nb-attachments", visited.getAttachmentList().size());
        item.put("step-type", "action");
        item.put("call-step-info", null);
        item.put("empty-requirements-holder", null);
        item.put("empty-browse-holder", null);
        item.put("empty-delete-holder", null);
        item.put("has-requirements", !visited.getRequirementVersionCoverages().isEmpty());
        item.put("nb-requirements", visited.getRequirementVersionCoverages().size());
        this.appendCustomFields(item);
        this.lastBuiltItem = item;
    }

    public void visit(KeywordTestStep visited) {
        HashMap item = new HashMap(4);
        item.put(STEP_ID, visited.getId());
        item.put("step-index", this.getCurrentIndex());
        item.put("step-type", "keyword");
        item.put("keyword-step-info", new KeywordStepInfo(visited));
        this.lastBuiltItem = item;
    }

    public void visit(CallTestStep visited) {
        HashMap<Object, Object> item = new HashMap<Object, Object>(11);
        item.put(STEP_ID, visited.getId());
        item.put("step-index", this.getCurrentIndex());
        item.put("attach-list-id", null);
        item.put("step-action", null);
        item.put("step-result", null);
        item.put("nb-attachments", null);
        item.put("step-type", "call");
        item.put("call-step-info", new CallStepInfo(visited));
        item.put("empty-requirements-holder", null);
        item.put("empty-browse-holder", null);
        item.put("empty-delete-holder", null);
        item.put("has-requirements", false);
        item.put("nb-requirements", null);
        this.appendCustomFields(item);
        this.lastBuiltItem = item;
    }

    private void appendCustomFields(Map<Object, Object> item) {
        Map<String, CustomFieldValueTableModel> cufValues = this.getCustomFieldsFor((Long)item.get(STEP_ID));
        item.put("customFields", cufValues);
    }

    public void usingCustomFields(Collection<CustomFieldValue> cufValues, int nbFieldsPerEntity) {
        this.customFieldValuesById = new HashMap<Long, Map<String, CustomFieldValueTableModel>>();
        for (CustomFieldValue value : cufValues) {
            Long entityId = value.getBoundEntityId();
            Map<String, CustomFieldValueTableModel> values = this.customFieldValuesById.get(entityId);
            if (values == null) {
                values = new HashMap<String, CustomFieldValueTableModel>(nbFieldsPerEntity);
                this.customFieldValuesById.put(entityId, values);
            }
            values.put(value.getCustomField().getCode(), new CustomFieldValueTableModel(value));
        }
    }

    private Map<String, CustomFieldValueTableModel> getCustomFieldsFor(Long id) {
        if (this.customFieldValuesById == null) {
            return new HashMap<String, CustomFieldValueTableModel>();
        }
        Map<String, CustomFieldValueTableModel> values = this.customFieldValuesById.get(id);
        if (values == null) {
            values = new HashMap<String, CustomFieldValueTableModel>();
        }
        return values;
    }

    public void usingCustomFields(Collection<CustomFieldValue> cufValues) {
        this.usingCustomFields(cufValues, 16);
    }

    public static final class CallStepInfo {
        private Long calledTcId;
        private String calledTcName;
        private Long calledDatasetId;
        private String calledDatasetName;
        private String paramMode;

        CallStepInfo(CallTestStep step) {
            this.calledTcId = step.getCalledTestCase().getId();
            this.calledTcName = step.getCalledTestCase().getName();
            this.paramMode = step.getParameterAssignationMode().toString();
            if (step.getParameterAssignationMode() == ParameterAssignationMode.CALLED_DATASET) {
                this.calledDatasetId = step.getCalledDataset().getId();
                this.calledDatasetName = step.getCalledDataset().getName();
            }
        }

        public Long getCalledTcId() {
            return this.calledTcId;
        }

        public String getCalledTcName() {
            return this.calledTcName;
        }

        public Long getCalledDatasetId() {
            return this.calledDatasetId;
        }

        public String getCalledDatasetName() {
            return this.calledDatasetName;
        }

        public String getParamMode() {
            return this.paramMode;
        }
    }

    protected static class CustomFieldValueTableModel {
        private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldValueTableModel.class);
        private String value;
        private List<String> values;
        private Long id;

        public CustomFieldValueTableModel() {
        }

        private CustomFieldValueTableModel(CustomFieldValue value) {
            this.id = value.getId();
            if (MultiValuedCustomFieldValue.class.isAssignableFrom(value.getClass())) {
                ArrayList<String> escapedValues = new ArrayList<String>();
                List rawValues = ((MultiValuedCustomFieldValue)value).getValues();
                if (rawValues != null) {
                    for (String string : rawValues) {
                        escapedValues.add(HTMLCleanupUtils.cleanHtml(string));
                    }
                }
                this.values = escapedValues;
            } else {
                this.value = NumericCustomFieldValue.class.isAssignableFrom(value.getClass()) ? NumericCufHelper.formatOutputNumericCufValue((String)value.getValue()) : HTMLCleanupUtils.cleanHtml(value.getValue());
            }
        }

        public Object getValue() {
            return this.value != null ? this.value : this.values;
        }

        public void setValue(Object value) {
            if (List.class.isAssignableFrom(value.getClass())) {
                this.values = (List)value;
            } else if (String.class.isAssignableFrom(value.getClass())) {
                this.value = (String)value;
            } else {
                throw new IllegalArgumentException("type '" + value.getClass() + "' not supported");
            }
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Date getValueAsDate() {
            try {
                return DateUtils.parseIso8601Date((String)this.value);
            }
            catch (ClassCastException | ParseException e) {
                LOGGER.debug("Unable to parse date {} of custom field #{}", new Object[]{this.value, this.id, e});
                return null;
            }
        }
    }

    public static final class KeywordStepInfo {
        private String keywordI18nKey;
        private String actionWord;

        KeywordStepInfo(KeywordTestStep step) {
            this.keywordI18nKey = step.getKeyword().i18nKeywordNameKey();
            this.actionWord = step.writeTestStepActionWordScript(false);
        }

        public String getKeywordI18nKey() {
            return this.keywordI18nKey;
        }

        public String getActionWord() {
            return this.actionWord;
        }
    }
}

