/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepViewFromExec;

class TestStepViewFromExecBuilder
implements TestStepVisitor {
    private TestStepViewFromExec testStepView;
    private ExecutionStep execStep;

    TestStepViewFromExecBuilder() {
    }

    public TestStepViewFromExec buildTestStepViewFromExec(ExecutionStep execStep) {
        this.execStep = this.findExistingStep(execStep);
        TestStep testStep = this.execStep.getReferencedTestStep();
        testStep.accept((TestStepVisitor)this);
        return this.testStepView;
    }

    public void visit(ActionTestStep visited) {
        this.testStepView = new TestStepViewFromExec(visited, this.execStep);
    }

    public void visit(CallTestStep visited) {
    }

    public void visit(KeywordTestStep visited) {
        throw new UnsupportedOperationException();
    }

    private ExecutionStep findExistingStep(ExecutionStep execStep) {
        int stepIndex;
        Execution exec = execStep.getExecution();
        ArrayList execSteps = new ArrayList(exec.getSteps());
        List after = execSteps.subList(stepIndex = exec.getStepIndex(execStep.getId().longValue()), execSteps.size());
        ExecutionStep result = (ExecutionStep)CollectionUtils.find(after, (Predicate)TestStepViewFromExec.NOT_DELETED);
        if (result == null) {
            List before = execSteps.subList(0, stepIndex);
            Collections.reverse(before);
            result = (ExecutionStep)CollectionUtils.find(before, (Predicate)TestStepViewFromExec.NOT_DELETED);
        }
        return result;
    }
}

