/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.web.internal.controller.testcase.steps.AbstractTestStepView;

public class TestStepViewFromExec
extends AbstractTestStepView<ExecutionStep> {
    public static final Predicate NOT_DELETED = new Predicate(){

        public boolean evaluate(Object step) {
            return ((ExecutionStep)step).getReferencedTestStep() != null;
        }
    };
    private boolean isCallStep = false;
    private String callStepName;

    public String getCallStepName() {
        return this.callStepName;
    }

    public boolean isCallStep() {
        return this.isCallStep;
    }

    public TestStepViewFromExec(ActionTestStep visited, ExecutionStep execStep) {
        this.genericSettings(execStep);
        this.actionStep = visited;
    }

    private void genericSettings(ExecutionStep execStep) {
        Execution exec = execStep.getExecution();
        List<ExecutionStep> execSteps = this.getNonDeletedSteps(execStep);
        int size = execSteps.size();
        this.testCase = exec.getReferencedTestCase();
        if (!this.testCase.getId().equals(execStep.getReferencedTestStep().getTestCase().getId())) {
            this.isCallStep = true;
            this.callStepName = execStep.getReferencedTestStep().getTestCase().getName();
        }
        this.setTotalNumberOfSteps(size);
        int stepIndex = this.getStepIndex(execSteps, execStep.getId());
        this.order = stepIndex + 1;
        if (stepIndex > 0) {
            this.previousStep = execSteps.get(stepIndex - 1);
        }
        if (this.order < size) {
            this.nextStep = execSteps.get(stepIndex + 1);
        }
        this.id = execStep.getReferencedTestStep().getId();
    }

    private int getStepIndex(List<ExecutionStep> steps, Long stepId) {
        for (ExecutionStep step : steps) {
            if (!step.getId().equals(stepId)) continue;
            return steps.indexOf(step);
        }
        return -1;
    }

    private List<ExecutionStep> getNonDeletedSteps(ExecutionStep execStep) {
        Execution exec = execStep.getExecution();
        ArrayList<ExecutionStep> execSteps = new ArrayList<ExecutionStep>(exec.getSteps());
        this.removeDeletedSteps(execSteps);
        return execSteps;
    }

    private void removeDeletedSteps(List<ExecutionStep> allSteps) {
        CollectionUtils.filter(allSteps, (Predicate)NOT_DELETED);
    }
}

