/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.TestStepModificationService;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.requirement.RequirementVerifierView;
import org.squashtest.tm.web.internal.controller.testcase.steps.AbstractTestStepView;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepUpdateFormModel;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepView;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepViewBuilder;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepViewFromExec;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepViewFromExecBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Controller
@RequestMapping(value={"/test-steps/{testStepId}"})
public class TestStepController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestStepController.class);
    private static final String OPTIMIZED = "optimized";
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    @Inject
    private TestStepModificationService testStepService;
    @Inject
    private CustomFieldValueFinderService cufValueFinder;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentHelper;
    @Inject
    private CustomFieldJsonConverter cufJsonConverter;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    private ExecutionFinder executionService;

    @RequestMapping(method={RequestMethod.GET})
    public String showStepInfos(@PathVariable long testStepId, Model model) {
        LOGGER.info("Show Test Step initiated");
        LOGGER.debug("Find and show TestStep #{}", (Object)testStepId);
        TestStep testStep = this.testStepService.findById(testStepId);
        TestStepView testStepView = new TestStepViewBuilder().buildTestStepView(testStep);
        this.generateTestStepInfo(model, testStepView, testStep);
        return "edit-test-step.html";
    }

    private void generateTestStepInfo(Model model, AbstractTestStepView<?> testStepView, TestStep testStep) {
        Locale locale = LocaleContextHolder.getLocale();
        model.addAttribute("testStepView", testStepView);
        if (testStepView.actionStep != null) {
            model.addAttribute("testStepViewAction", (Object)testStepView.actionStep.getAction());
            model.addAttribute("testStepViewExpectedResult", (Object)testStepView.actionStep.getExpectedResult());
        }
        model.addAttribute("workspace", (Object)"test-case");
        model.addAttribute("testCase", (Object)testStepView.testCase);
        model.addAttribute("testStep", (Object)testStep);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testStep.getTestCase());
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        boolean writable = this.permissionEvaluationService.hasRoleOrPermissionOnObject(ROLE_ADMIN, "WRITE", (Object)testStep);
        writable = writable && milestoneConf.isEditable();
        model.addAttribute("writable", (Object)writable);
        boolean attachable = this.permissionEvaluationService.hasRoleOrPermissionOnObject(ROLE_ADMIN, "ATTACH", (Object)testStep);
        attachable = attachable && milestoneConf.isEditable();
        model.addAttribute("attachable", (Object)attachable);
        boolean linkable = this.permissionEvaluationService.hasRoleOrPermissionOnObject(ROLE_ADMIN, "LINK", (Object)testStep);
        model.addAttribute("linkable", (Object)linkable);
        boolean hasCUF = false;
        List values = Collections.emptyList();
        if (testStepView.getActionStep() != null) {
            model.addAttribute("attachableEntity", (Object)testStepView.getActionStep());
            Set<Attachment> attachments = this.attachmentHelper.findAttachments((AttachmentHolder)testStepView.getActionStep());
            model.addAttribute("attachmentSet", attachments);
            values = this.cufValueFinder.findAllCustomFieldValues(testStepView.getActionStep().getBoundEntityId().longValue(), testStepView.getActionStep().getBoundEntityType());
            hasCUF = this.cufValueFinder.hasCustomFields((BoundEntity)testStepView.getActionStep());
            RequirementVerifierView requirementVerifierView = new RequirementVerifierView(testStepView.getActionStep(), this.internationalizationHelper, locale);
            model.addAttribute("requirementVerifier", (Object)requirementVerifierView);
        } else {
            values = Collections.emptyList();
        }
        ArrayList<CustomFieldValueModel> cufModels = new ArrayList<CustomFieldValueModel>(values.size());
        for (CustomFieldValue value : values) {
            cufModels.add(this.cufJsonConverter.toJson(value));
        }
        model.addAttribute("cufDefinitions", cufModels);
        model.addAttribute("hasCUF", (Object)hasCUF);
    }

    @RequestMapping(value={"/from-exec"}, method={RequestMethod.GET}, params={"optimized"})
    public String showStepInfosFromExec(@PathVariable(value="testStepId") int execStepId, Model model, @RequestParam(value="optimized") boolean optimized) {
        ExecutionStep execStep = this.executionService.findExecutionStepById((long)execStepId);
        TestStep testStep = execStep.getReferencedTestStep();
        TestStepViewFromExec testStepView = new TestStepViewFromExecBuilder().buildTestStepViewFromExec(execStep);
        if (testStep != null) {
            this.generateTestStepInfo(model, testStepView, testStep);
        } else {
            model.addAttribute("testStepView", (Object)testStepView);
            if (testStepView.actionStep != null) {
                model.addAttribute("testStepViewAction", (Object)HtmlUtils.htmlEscape((String)testStepView.actionStep.getAction()));
                model.addAttribute("testStepViewExpectedResult", (Object)HtmlUtils.htmlEscape((String)testStepView.actionStep.getExpectedResult()));
            }
            model.addAttribute("workspace", (Object)"test-case");
            model.addAttribute("writable", (Object)true);
        }
        model.addAttribute("fromExec", (Object)execStep.getExecution().getId());
        model.addAttribute("isIEO", (Object)optimized);
        return "edit-test-step.html";
    }

    @RequestMapping(method={RequestMethod.POST}, headers={"Content-Type=application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateStep(@PathVariable Long testStepId, @RequestBody TestStepUpdateFormModel testStepModel) {
        this.testStepService.updateTestStep(testStepId, testStepModel.getAction(), testStepModel.getExpectedResult(), testStepModel.getCufs());
    }
}

