/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.actionword.ActionWordService;
import org.squashtest.tm.service.customfield.CustomFieldHelper;
import org.squashtest.tm.service.customfield.CustomFieldHelperService;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.repository.KeywordTestStepDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseFinder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseModificationController;
import org.squashtest.tm.web.internal.controller.testcase.steps.ActionStepFormModel;
import org.squashtest.tm.web.internal.controller.testcase.steps.KeywordTestStepModel;
import org.squashtest.tm.web.internal.controller.testcase.steps.KeywordTestStepTableModelBuilder;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepsTableModelBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTablePaging;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/test-cases/{testCaseId}/steps"})
public class TestCaseTestStepsController {
    private static final String TEST_CASE = "testCase";
    private static final String TEST_CASE_ = "test case ";
    @Inject
    private CustomFieldHelperService cufHelperService;
    @Inject
    private KeywordTestCaseFinder keywordTestCaseFinder;
    @Inject
    private KeywordTestStepDao keywordTestStepDao;
    @Autowired(required=false)
    private ActionWordService actionWordService;
    @Inject
    private CustomFieldJsonConverter converter;
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    private CallStepManagerService callStepManager;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    private static final String COPIED_STEP_ID_PARAM = "copiedStepId[]";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseModificationController.class);

    @RequestMapping(value={"/panel"})
    public String getTestStepsPanel(@PathVariable(value="testCaseId") long testCaseId, Model model) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        List steps = testCase.getSteps().subList(0, Math.min(50, testCase.getSteps().size()));
        CustomFieldHelper helper = this.cufHelperService.newStepsHelper(steps, testCase.getProject()).setRenderingLocations(new RenderingLocation[]{RenderingLocation.STEP_TABLE}).restrictToCommonFields();
        List<CustomFieldModel> cufDefinitions = this.convertToJsonCustomField(helper.getCustomFieldConfiguration());
        List cufValues = helper.getCustomFieldValues();
        TestStepsTableModelBuilder builder = new TestStepsTableModelBuilder();
        builder.usingCustomFields(cufValues, cufDefinitions.size());
        List<Object> stepsData = builder.buildRawModel(steps, 1);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testCase);
        model.addAttribute(TEST_CASE, (Object)testCase);
        model.addAttribute("stepsData", stepsData);
        model.addAttribute("cufDefinitions", cufDefinitions);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        return "test-cases-tabs/test-steps-tab.html";
    }

    @RequestMapping(params={"sEcho"})
    @ResponseBody
    public DataTableModel getStepsTableModel(@PathVariable long testCaseId, DataTableDrawParameters params) {
        LOGGER.trace("TestCaseModificationController: getStepsTableModel called ");
        DataTablePaging filter = new DataTablePaging(params);
        PagedCollectionHolder holder = this.testCaseModificationService.findStepsByTestCaseIdFiltered(testCaseId, (Paging)filter);
        Project project = this.testCaseModificationService.findById(testCaseId).getProject();
        CustomFieldHelper helper = this.cufHelperService.newStepsHelper((List)holder.getPagedItems(), project).setRenderingLocations(new RenderingLocation[]{RenderingLocation.STEP_TABLE}).restrictToCommonFields();
        List cufValues = helper.getCustomFieldValues();
        TestStepsTableModelBuilder builder = new TestStepsTableModelBuilder();
        builder.usingCustomFields(cufValues);
        return builder.buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/keyword-test-step-table"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getKeywordTestStepTableModel(@PathVariable long testCaseId, DataTableDrawParameters params) {
        DataTablePaging filter = new DataTablePaging(params);
        PagedCollectionHolder holder = this.testCaseModificationService.findStepsByTestCaseIdFiltered(testCaseId, (Paging)filter);
        KeywordTestStepTableModelBuilder builder = new KeywordTestStepTableModelBuilder(this.permissionService);
        return builder.buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Long addActionTestStep(@RequestBody ActionStepFormModel stepModel, @PathVariable long testCaseId) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)stepModel, "add-test-step");
        ActionStepFormModel.ActionStepFormModelValidator validator = new ActionStepFormModel.ActionStepFormModelValidator(this.internationalizationHelper);
        validator.validate(stepModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        ActionTestStep step = stepModel.getActionTestStep();
        Map<Long, RawValue> customFieldValues = stepModel.getCufs();
        int index = stepModel.getIndex();
        ActionTestStep addActionTestStep = index != 0 ? this.testCaseModificationService.addActionTestStep(testCaseId, step, customFieldValues, index) : this.testCaseModificationService.addActionTestStep(testCaseId, step, customFieldValues);
        LOGGER.trace(TEST_CASE_ + testCaseId + ": step added, action : " + step.getAction() + ", expected result : " + step.getExpectedResult());
        return addActionTestStep.getId();
    }

    @RequestMapping(value={"/keyword-test-step-panel"})
    public String getKeywordTestStepPanel(@PathVariable(value="testCaseId") long testCaseId, Model model) {
        KeywordTestCase keywordTestCase = this.keywordTestCaseFinder.findById(testCaseId);
        List steps = keywordTestCase.getSteps();
        model.addAttribute(TEST_CASE, (Object)keywordTestCase);
        model.addAttribute("projectId", (Object)keywordTestCase.getProject().getId());
        KeywordTestStepTableModelBuilder builder = new KeywordTestStepTableModelBuilder(this.permissionService);
        List<Object> stepData = builder.buildRawModel(steps, 1);
        model.addAttribute("isAutocompleteActive", (Object)Objects.nonNull(this.actionWordService));
        model.addAttribute("stepData", stepData);
        model.addAttribute("keywordMap", this.createKeywordMap(keywordTestCase.getProject()));
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure((TestCase)keywordTestCase);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        return "test-cases-tabs/keyword-test-steps-tab.html";
    }

    @PostMapping(value={"/add-keyword-test-step"}, consumes={"application/json"})
    @ResponseBody
    public Long addKeywordTestStep(@RequestBody KeywordTestStepModel keywordTestStepDto, @PathVariable long testCaseId) throws BindException {
        this.validateDto(keywordTestStepDto);
        String keyword = keywordTestStepDto.getKeyword();
        String actionWord = keywordTestStepDto.getActionWord();
        int index = keywordTestStepDto.getIndex();
        KeywordTestStep step = index != 0 ? this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord, index) : this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord);
        return step.getId();
    }

    @PostMapping(value={"/add-keyword-test-step-with-action-word-id"}, consumes={"application/json"})
    @ResponseBody
    public Long addKeywordTestStepWithActionWordId(@RequestBody KeywordTestStepModel keywordTestStepDto, @PathVariable long testCaseId) throws BindException {
        this.validateDto(keywordTestStepDto);
        String keyword = keywordTestStepDto.getKeyword();
        String actionWord = keywordTestStepDto.getActionWord();
        int index = keywordTestStepDto.getIndex();
        long actionWordId = keywordTestStepDto.getActionWordId();
        KeywordTestStep step = this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord, Long.valueOf(actionWordId), index);
        return step.getId();
    }

    private void validateDto(@RequestBody KeywordTestStepModel keywordTestStepDto) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)keywordTestStepDto, "add-keyword-test-step");
        KeywordTestStepModel.KeywordTestStepModelValidator validator = new KeywordTestStepModel.KeywordTestStepModelValidator(this.internationalizationHelper);
        validator.validate(keywordTestStepDto, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    @RequestMapping(value={"/paste"}, method={RequestMethod.POST}, params={"copiedStepId[]"})
    @ResponseBody
    public boolean pasteStep(@RequestParam(value="copiedStepId[]") List<Long> copiedStepIds, @RequestParam(value="idPosition") long idPosition, @PathVariable long testCaseId) {
        this.callStepManager.checkForCyclicStepCallBeforePaste(testCaseId, copiedStepIds);
        return this.testCaseModificationService.pasteCopiedTestSteps(testCaseId, idPosition, copiedStepIds);
    }

    @RequestMapping(value={"/paste-last-index"}, method={RequestMethod.POST}, params={"copiedStepId[]"})
    @ResponseBody
    public boolean pasteStepLastIndex(@RequestParam(value="copiedStepId[]") List<Long> copiedStepIds, @PathVariable long testCaseId) {
        this.callStepManager.checkForCyclicStepCallBeforePaste(testCaseId, copiedStepIds);
        return this.testCaseModificationService.pasteCopiedTestStepToLastIndex(testCaseId, copiedStepIds);
    }

    @RequestMapping(value={"/{stepId}"}, method={RequestMethod.POST}, params={"newIndex"})
    @ResponseBody
    public void changeStepIndex(@PathVariable long stepId, @RequestParam int newIndex, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeTestStepPosition(testCaseId, stepId, newIndex);
        LOGGER.trace(TEST_CASE_ + testCaseId + ": step " + stepId + " moved to " + newIndex);
    }

    @RequestMapping(value={"/move"}, method={RequestMethod.POST}, params={"newIndex", "itemIds[]"})
    @ResponseBody
    public void changeStepsIndex(@RequestParam(value="itemIds[]") List<Long> itemIds, @RequestParam(value="newIndex") int newIndex, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeTestStepsPosition(testCaseId, newIndex, itemIds);
    }

    @RequestMapping(value={"/{stepIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public int deleteSteps(@PathVariable(value="stepIds") List<Long> stepIds, @PathVariable long testCaseId) {
        List teststeps = this.testCaseModificationService.removeListOfSteps(testCaseId, stepIds);
        return teststeps.size();
    }

    @RequestMapping(value={"/{stepId}/action"}, method={RequestMethod.POST}, params={"id", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeStepAction(@PathVariable long stepId, @RequestParam(value="value") String newAction) {
        this.testCaseModificationService.updateTestStepAction(stepId, newAction);
        LOGGER.trace("TestCaseModificationController : updated action for step {}", (Object)stepId);
        return HTMLCleanupUtils.cleanHtml(newAction);
    }

    @RequestMapping(value={"/{stepId}/result"}, method={RequestMethod.POST}, params={"id", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeStepDescription(@PathVariable long stepId, @RequestParam(value="value") String newResult) {
        this.testCaseModificationService.updateTestStepExpectedResult(stepId, newResult);
        LOGGER.trace("TestCaseModificationController : updated action for step {}", (Object)stepId);
        return HTMLCleanupUtils.cleanHtml(newResult);
    }

    @RequestMapping(value={"{stepId}/parameter-assignation-mode"}, method={RequestMethod.POST}, params={"mode", "datasetId"})
    @ResponseBody
    public void changeParameterAssignationMode(@PathVariable(value="stepId") Long stepId, @RequestParam(value="mode") ParameterAssignationMode mode, @RequestParam(value="datasetId", required=false) Long datasetId) {
        this.callStepManager.setParameterAssignationMode(stepId.longValue(), mode, datasetId);
    }

    @RequestMapping(value={"/{stepId}/keyword"}, method={RequestMethod.POST}, params={"id", "value"})
    @ResponseBody
    public String changeStepKeyword(@PathVariable long stepId, @RequestParam(value="value") String keyword) {
        Keyword updatedKeyword = Keyword.valueOf((String)keyword);
        this.testCaseModificationService.updateKeywordTestStep(stepId, updatedKeyword);
        LOGGER.trace("TestCaseModificationController : updated keyword for step {}", (Object)stepId);
        Locale locale = this.keywordTestStepDao.findById(stepId).getTestCase().getProject().getBddScriptLanguage().getLocale();
        return this.internationalizationHelper.internationalize(updatedKeyword.i18nKeywordNameKey(), locale);
    }

    @RequestMapping(value={"/{stepId}/action-word"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeStepActionWord(@PathVariable long stepId, @RequestParam(value="value") String actionWord) {
        this.testCaseModificationService.updateKeywordTestStep(stepId, actionWord);
        LOGGER.trace("TestCaseModificationController : updated action word for step {}", (Object)stepId);
        return actionWord;
    }

    @ResponseBody
    @RequestMapping(value={"/{stepId}/duplicated-action"}, method={RequestMethod.GET}, params={"projectId", "inputActionWord"})
    public Map<String, Long> findAllDuplicatedActionWithProject(@PathVariable long stepId, @RequestParam long projectId, @RequestParam String inputActionWord) {
        return this.actionWordService.findAllDuplicatedActionWithProjectWithChangingToken(projectId, stepId, inputActionWord);
    }

    @RequestMapping(value={"/{stepId}/action-word-with-id"})
    @ResponseBody
    public String changeStepActionWordWithId(@PathVariable long stepId, @RequestParam(value="actionWord") String actionWord, @RequestParam(value="actionWordId") long actionWordId) {
        this.testCaseModificationService.updateKeywordTestStep(stepId, actionWord, actionWordId);
        LOGGER.trace("TestCaseModificationController : updated action word for step {} with action word id {}", (Object)stepId, (Object)actionWordId);
        return actionWord;
    }

    @RequestMapping(value={"/{stepId}/datatable"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeKeywordStepDatatable(@PathVariable long stepId, @RequestParam(value="value") String datatable) {
        this.testCaseModificationService.updateKeywordTestStepDatatable(stepId, datatable);
        LOGGER.trace("TestCaseModificationController : updated datatable for step {}", (Object)stepId);
        return HtmlUtils.htmlEscape((String)datatable);
    }

    @RequestMapping(value={"/{stepId}/docstring"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeKeywordStepDocstring(@PathVariable long stepId, @RequestParam(value="value") String docstring) {
        this.testCaseModificationService.updateKeywordTestStepDocstring(stepId, docstring);
        LOGGER.trace("TestCaseModificationController : updated docstring for step {}", (Object)stepId);
        return HtmlUtils.htmlEscape((String)docstring);
    }

    @RequestMapping(value={"/{stepId}/comment"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeKeywordStepComment(@PathVariable long stepId, @RequestParam(value="value") String comment) {
        this.testCaseModificationService.updateKeywordTestStepComment(stepId, comment);
        LOGGER.trace("TestCaseModificationController : updated comment for step {}", (Object)stepId);
        return HtmlUtils.htmlEscape((String)comment);
    }

    private List<CustomFieldModel> convertToJsonCustomField(Collection<CustomField> customFields) {
        ArrayList<CustomFieldModel> models = new ArrayList<CustomFieldModel>(customFields.size());
        for (CustomField field : customFields) {
            models.add(this.converter.toJson(field));
        }
        return models;
    }

    private EnumMap<Keyword, String> createKeywordMap(Project project) {
        Locale locale = project.getBddScriptLanguage().getLocale();
        EnumMap<Keyword, String> keywordMap = new EnumMap<Keyword, String>(Keyword.class);
        Keyword[] keywordArray = Keyword.values();
        int n = keywordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Keyword keyword = keywordArray[n2];
            keywordMap.put(keyword, this.internationalizationHelper.internationalize(keyword.i18nKeywordNameKey(), locale));
            ++n2;
        }
        return keywordMap;
    }
}

