/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.actionword.ActionWordFragmentVisitor;
import org.squashtest.tm.domain.actionword.ConsumerForActionWordFragmentVisitor;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class KeywordTestStepTableModelBuilder
extends DataTableModelBuilder<TestStep> {
    private PermissionEvaluationService permissionService;

    @Override
    protected Object buildItemData(TestStep step) {
        KeywordTestStep keywordTestStep = (KeywordTestStep)step;
        HashMap<String, String> item = new HashMap<String, String>(12);
        item.put("entity-id", step.getId().toString());
        item.put("step-index", String.valueOf(this.getCurrentIndex()));
        item.put("step-keyword", String.valueOf(keywordTestStep.getKeyword()));
        String actionWordWithParamValues = this.createActionWordWithParamValues(keywordTestStep);
        item.put("step-action-word", actionWordWithParamValues);
        item.put("step-action-word-unstyled", keywordTestStep.writeTestStepActionWordScript(true));
        item.put("toggle-step-details", null);
        item.put("step-datatable", keywordTestStep.getDatatable() != null ? HtmlUtils.htmlEscape((String)keywordTestStep.getDatatable()) : "");
        item.put("step-docstring", keywordTestStep.getDocstring() != null ? HtmlUtils.htmlEscape((String)keywordTestStep.getDocstring()) : "");
        item.put("step-comment", keywordTestStep.getComment() != null ? HtmlUtils.htmlEscape((String)keywordTestStep.getComment()) : "");
        item.put("action-word-id", this.retrieveActionWordIdIfReadable(keywordTestStep.getActionWord().getId()));
        item.put("step-action-word-url", null);
        item.put("empty-delete-holder", null);
        return item;
    }

    public KeywordTestStepTableModelBuilder(PermissionEvaluationService permissionService) {
        this.permissionService = permissionService;
    }

    public String createActionWordWithParamValues(KeywordTestStep keywordTestStep) {
        ActionWord actionWord = keywordTestStep.getActionWord();
        List fragments = actionWord.getFragments();
        List paramValues = keywordTestStep.getParamValues();
        return this.createWord(fragments, paramValues);
    }

    private String createWord(List<ActionWordFragment> fragments, List<ActionWordParameterValue> paramValues) {
        StringBuilder builder = new StringBuilder();
        Consumer<ActionWordParameter> consumer = parameter -> this.appendParamValueToCreateWord((ActionWordParameter)parameter, paramValues, builder);
        ConsumerForActionWordFragmentVisitor visitor = new ConsumerForActionWordFragmentVisitor(consumer, builder);
        for (ActionWordFragment fragment : fragments) {
            fragment.accept((ActionWordFragmentVisitor)visitor);
        }
        return builder.toString();
    }

    private void appendParamValueToCreateWord(ActionWordParameter param, List<ActionWordParameterValue> paramValues, StringBuilder builder) {
        Optional<ActionWordParameterValue> paramValue = paramValues.stream().filter(pv -> pv.getActionWordParam() != null && pv.getActionWordParam().getId().equals(param.getId())).findAny();
        paramValue.ifPresent(actionWordParameterValue -> this.addParamValueToBuilder(builder, (ActionWordParameterValue)actionWordParameterValue));
    }

    private void addParamValueToBuilder(StringBuilder builder, ActionWordParameterValue actionWordParameterValue) {
        String replaceHTMLCharactersStr = StringEscapeUtils.escapeHtml4((String)actionWordParameterValue.getValue());
        builder.append("<span style=\"color: blue;\">").append(replaceHTMLCharactersStr).append("</span>");
    }

    private String retrieveActionWordIdIfReadable(Long actionWordId) {
        return this.isActionWordReadable(actionWordId) ? actionWordId.toString() : "";
    }

    private boolean isActionWordReadable(Long actionWordId) {
        return this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "READ", actionWordId, ActionWord.class.getName());
    }
}

