/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseLibraryFinderService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;

@Controller
public class CallStepManagerController {
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilder;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    @Named(value="testCaseWorkspaceDisplayService")
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    @Inject
    protected UserAccountService userAccountService;
    private CallStepManagerService callStepManagerService;
    private TestCaseLibraryFinderService testCaseLibraryFinder;

    @Inject
    public void setCallStepManagerService(CallStepManagerService callStepManagerService) {
        this.callStepManagerService = callStepManagerService;
    }

    @RequestMapping(value={"/test-cases/{testCaseId}/called-test-cases/manager"}, method={RequestMethod.GET})
    public ModelAndView showManager(@PathVariable long testCaseId, @RequestParam(value="step-index") Long stepIndex, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes) {
        TestCase testCase = this.callStepManagerService.findTestCase(testCaseId);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectId = this.testCaseLibraryFinder.findLinkableTestCaseLibraries().stream().map(TestCaseLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.testCaseWorkspaceDisplayService.findAllLibraries(projectId, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        ModelAndView mav = new ModelAndView("page/test-case-workspace/show-call-step-manager");
        mav.addObject("testCase", (Object)testCase);
        mav.addObject("rootModel", (Object)linkableLibrariesModel);
        mav.addObject("stepIndex", (Object)stepIndex);
        return mav;
    }

    @RequestMapping(value={"/test-cases/{callingTestCaseId}/called-test-cases"}, method={RequestMethod.POST}, params={"called-test-case[]"})
    @ResponseBody
    public void addCallTestStep(@PathVariable(value="callingTestCaseId") long callingTestCaseId, @RequestParam(value="called-test-case[]") List<Long> calledTestCaseIds, @RequestParam(value="index") Integer index) {
        this.callStepManagerService.addCallTestSteps(callingTestCaseId, calledTestCaseIds, index);
    }

    private List<JsTreeNode> createLinkableLibrariesModel(List<TestCaseLibrary> linkableLibraries) {
        DriveNodeBuilder builder = (DriveNodeBuilder)this.driveNodeBuilder.get();
        ArrayList<JsTreeNode> linkableLibrariesModel = new ArrayList<JsTreeNode>();
        for (TestCaseLibrary library : linkableLibraries) {
            JsTreeNode libraryNode = ((DriveNodeBuilder)builder.setModel(library)).build();
            linkableLibrariesModel.add(libraryNode);
        }
        return linkableLibrariesModel;
    }

    @Inject
    public void setTestCaseLibraryFinder(TestCaseLibraryFinderService testCaseLibraryFinder) {
        this.testCaseLibraryFinder = testCaseLibraryFinder;
    }
}

