/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.steps;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.service.internal.dto.RawValueModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class ActionStepFormModel {
    private String action = "";
    private String expectedResult = "";
    private RawValueModel.RawValueModelMap customFields = new RawValueModel.RawValueModelMap();
    private int index;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    public RawValueModel.RawValueModelMap getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(RawValueModel.RawValueModelMap customFields) {
        this.customFields = customFields;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @JsonIgnore
    public Map<Long, RawValue> getCufs() {
        HashMap<Long, RawValue> cufs = new HashMap<Long, RawValue>(this.customFields.size());
        for (Map.Entry entry : this.customFields.entrySet()) {
            cufs.put((Long)entry.getKey(), ((RawValueModel)entry.getValue()).toRawValue());
        }
        return cufs;
    }

    public ActionTestStep getActionTestStep() {
        ActionTestStep newStep = new ActionTestStep();
        newStep.setAction(HTMLCleanupUtils.cleanHtml(this.action));
        newStep.setExpectedResult(HTMLCleanupUtils.cleanHtml(this.expectedResult));
        return newStep;
    }

    public static class ActionStepFormModelValidator
    implements Validator {
        private MessageSource messageSource;

        public ActionStepFormModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> clazz) {
            return clazz.equals(ActionStepFormModel.class);
        }

        public void validate(Object target, Errors errors) {
            Locale locale = LocaleContextHolder.getLocale();
            String notBlank = this.messageSource.getMessage("message.notBlank", null, locale);
            ActionStepFormModel model = (ActionStepFormModel)target;
            for (Map.Entry entry : model.getCustomFields().entrySet()) {
                RawValueModel value = (RawValueModel)entry.getValue();
                if (!value.isEmpty()) continue;
                errors.rejectValue("customFields[" + entry.getKey() + "]", "message.notBlank", notBlank);
            }
        }
    }
}

