/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.requirement.VerifiedRequirementException;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.TestStepModificationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.requirement.VerifiedRequirementsDataTableModelHelper;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.helper.VerifiedRequirementActionSummaryBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class VerifiedRequirementsManagerController {
    private static final String REQUIREMENTS_IDS = "requirementsIds[]";
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    @Named(value="requirement.driveNodeBuilder")
    private Provider<DriveNodeBuilder<RequirementLibraryNode>> driveNodeBuilder;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private TestStepModificationService testStepService;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private RequirementLibraryFinderService requirementLibraryFinder;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    @Named(value="requirementWorkspaceDisplayService")
    private WorkspaceDisplayService requirementWorkspaceDisplayService;
    @Inject
    protected UserAccountService userAccountService;
    private DatatableMapper<String> verifiedRequirementVersionsMapper = new NameBasedMapper(8).mapAttribute("entity-id", "id", RequirementVersion.class).mapAttribute("name", "name", RequirementVersion.class).mapAttribute("project", "name", Project.class).mapAttribute("reference", "reference", RequirementVersion.class).mapAttribute("versionNumber", "versionNumber", RequirementVersion.class).mapAttribute("criticality", "criticality", RequirementVersion.class).mapAttribute("category", "category", RequirementVersion.class).map("milestone-dates", "endDate");

    @RequestMapping(value={"/test-cases/{testCaseId}/verified-requirement-versions/manager"}, method={RequestMethod.GET})
    public String showTestCaseManager(@PathVariable long testCaseId, Model model, @CookieValue(value="jstree_verif_open", required=false, defaultValue="") String[] openedNodes) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        PermissionsUtils.checkPermission((PermissionEvaluationService)this.permissionService, (SecurityCheckableObject[])new SecurityCheckableObject[]{new SecurityCheckableObject((Object)testCase, "LINK")});
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testCase);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.requirementLibraryFinder.findLinkableRequirementLibraries().stream().map(RequirementLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.requirementWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        model.addAttribute("testCase", (Object)testCase);
        model.addAttribute("linkableLibrariesModel", (Object)linkableLibrariesModel);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        IsScriptedTestCaseVisitor visitor = new IsScriptedTestCaseVisitor();
        testCase.accept((TestCaseVisitor)visitor);
        model.addAttribute("isTcScripted", (Object)visitor.isScripted());
        return "page/test-case-workspace/show-verified-requirements-manager";
    }

    @RequestMapping(value={"/test-steps/{testStepId}/verified-requirement-versions/manager"}, method={RequestMethod.GET})
    public String showTestStepManager(@PathVariable long testStepId, Model model, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes) {
        TestStep testStep = this.testStepService.findById(testStepId);
        PermissionsUtils.checkPermission((PermissionEvaluationService)this.permissionService, (SecurityCheckableObject[])new SecurityCheckableObject[]{new SecurityCheckableObject((Object)testStep, "LINK")});
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testStep.getTestCase());
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.requirementLibraryFinder.findLinkableRequirementLibraries().stream().map(RequirementLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.requirementWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        model.addAttribute("testStep", (Object)testStep);
        model.addAttribute("linkableLibrariesModel", (Object)linkableLibrariesModel);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        return "page/test-case-workspace/show-step-verified-requirements-manager";
    }

    private List<JsTreeNode> createLinkableLibrariesModel(String[] openedNodes) {
        List linkableLibraries = this.requirementLibraryFinder.findLinkableRequirementLibraries();
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        DriveNodeBuilder nodeBuilder = (DriveNodeBuilder)this.driveNodeBuilder.get();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            nodeBuilder.filterByMilestone((Milestone)activeMilestone.get());
        }
        return new JsTreeNodeListBuilder(nodeBuilder).expand(expansionCandidates).setModel(linkableLibraries).build();
    }

    @ResponseBody
    @RequestMapping(value={"/test-cases/{testCaseId}/verified-requirements"}, method={RequestMethod.POST}, params={"requirementsIds[]"})
    public Map<String, Object> addVerifiedRequirementsToTestCase(@RequestParam(value="requirementsIds[]") List<Long> requirementsIds, @PathVariable long testCaseId) {
        Collection rejections = this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestCase(requirementsIds, testCaseId);
        return this.buildSummary(rejections);
    }

    @ResponseBody
    @RequestMapping(value={"/test-steps/{testStepId}/verified-requirements"}, method={RequestMethod.POST}, params={"requirementsIds[]"})
    public Map<String, Object> addVerifiedRequirementsToTestStep(@RequestParam(value="requirementsIds[]") List<Long> requirementsIds, @PathVariable long testStepId) {
        Collection rejections = this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestStep(requirementsIds, testStepId);
        return this.buildSummary(rejections);
    }

    @ResponseBody
    @RequestMapping(value={"/test-steps/{testStepId}/verified-requirement-versions/{requirementVersionId}"}, method={RequestMethod.POST})
    public Map<String, Object> addVerifiedRequirementToTestStep(@PathVariable long requirementVersionId, @PathVariable long testStepId) {
        Collection rejections = this.verifiedRequirementsManagerService.addVerifiedRequirementVersionToTestStep(requirementVersionId, testStepId);
        return this.buildSummary(rejections);
    }

    @RequestMapping(value={"/test-cases/{testCaseId}/verified-requirement-versions/{oldVersionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public int changeVersion(@PathVariable long testCaseId, @PathVariable long oldVersionId, @RequestParam(value="value") long newVersionId) {
        ArrayList<Long> oldVersion = new ArrayList<Long>();
        oldVersion.add(oldVersionId);
        ArrayList<Long> newVersion = new ArrayList<Long>();
        newVersion.add(newVersionId);
        int newVersionNumber = this.verifiedRequirementsManagerService.changeVerifiedRequirementVersionOnTestCase(oldVersionId, newVersionId, testCaseId);
        return newVersionNumber;
    }

    private Map<String, Object> buildSummary(Collection<VerifiedRequirementException> rejections) {
        return VerifiedRequirementActionSummaryBuilder.buildAddActionSummary(rejections);
    }

    @ResponseBody
    @RequestMapping(value={"/test-cases/{testCaseId}/verified-requirement-versions/{requirementVersionsIds}"}, method={RequestMethod.DELETE})
    public void removeVerifiedRequirementVersionsFromTestCase(@PathVariable List<Long> requirementVersionsIds, @PathVariable long testCaseId) {
        this.verifiedRequirementsManagerService.removeVerifiedRequirementVersionsFromTestCase(requirementVersionsIds, testCaseId);
    }

    @ResponseBody
    @RequestMapping(value={"/test-steps/{testStepId}/verified-requirement-versions/{requirementVersionsIds}"}, method={RequestMethod.DELETE})
    public void removeVerifiedRequirementVersionsFromTestStep(@PathVariable List<Long> requirementVersionsIds, @PathVariable long testStepId) {
        this.verifiedRequirementsManagerService.removeVerifiedRequirementVersionsFromTestStep(requirementVersionsIds, testStepId);
    }

    @RequestMapping(value={"/test-cases/{testCaseId}/verified-requirement-versions"}, params={"sEcho", "includeCallSteps"})
    @ResponseBody
    public DataTableModel getTestCaseWithCallStepsVerifiedRequirementsTableModel(@PathVariable long testCaseId, DataTableDrawParameters params, Locale locale) {
        DataTableSorting pas = new DataTableSorting(params, this.verifiedRequirementVersionsMapper);
        PagedCollectionHolder holder = this.verifiedRequirementsManagerService.findAllVerifiedRequirementsByTestCaseId(testCaseId, (PagingAndSorting)pas);
        return new VerifiedRequirementsDataTableModelHelper.TestCaseWithCalledStepsVerifiedRequirementsDataTableModelHelper(locale, this.internationalizationHelper, this.permissionService).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/test-cases/{testCaseId}/verified-requirement-versions"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTestCaseVerifiedRequirementsTableModel(@PathVariable long testCaseId, DataTableDrawParameters params, Locale locale) {
        DataTableSorting pagingAndSorting = new DataTableSorting(params, this.verifiedRequirementVersionsMapper);
        PagedCollectionHolder holder = this.verifiedRequirementsManagerService.findAllDirectlyVerifiedRequirementsByTestCaseId(testCaseId, (PagingAndSorting)pagingAndSorting);
        return new VerifiedRequirementsDataTableModelHelper.TestCaseVerifiedRequirementsDataTableModelHelper(locale, this.internationalizationHelper, this.permissionService).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/test-steps/{testStepId}/verified-requirement-versions"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTestStepVerifiedRequirementTableModel(DataTableDrawParameters params, @PathVariable long testStepId) {
        DataTableSorting paging = new DataTableSorting(params, this.verifiedRequirementVersionsMapper);
        Locale locale = LocaleContextHolder.getLocale();
        PagedCollectionHolder holder = this.verifiedRequirementsManagerService.findAllDirectlyVerifiedRequirementsByTestStepId(testStepId, (PagingAndSorting)paging);
        TestCase testCase = this.testCaseModificationService.findTestCaseFromStep(testStepId);
        return new VerifiedRequirementsDataTableModelHelper.TestStepVerifiedRequirementsDataTableModelHelper(locale, this.internationalizationHelper, this.permissionService, testStepId, testCase).buildDataModel(holder, params.getsEcho());
    }
}

