/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.requirement;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.requirement.VerifiedRequirement;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

abstract class VerifiedRequirementsDataTableModelHelper
extends DataTableModelBuilder<VerifiedRequirement> {
    private InternationalizationHelper internationalizationHelper;
    private Locale locale;
    private PermissionEvaluationService permService;
    private static final int INT_MAX_DESCRIPTION_LENGTH = 50;

    VerifiedRequirementsDataTableModelHelper(Locale locale, InternationalizationHelper internationalizationHelper, PermissionEvaluationService permService) {
        this.locale = locale;
        this.internationalizationHelper = internationalizationHelper;
        this.permService = permService;
    }

    public Map<String, Object> buildItemData(VerifiedRequirement item) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("entity-id", item.getId());
        res.put("entity-index", this.getCurrentIndex());
        res.put("name", HtmlUtils.htmlEscape((String)item.getName()));
        res.put("project", HtmlUtils.htmlEscape((String)item.getProject().getName()));
        res.put("reference", HtmlUtils.htmlEscape((String)item.getReference()));
        res.put("versionNumber", item.getVersionNumber());
        res.put("criticality", this.internationalizationHelper.internationalize((Internationalizable)item.getCriticality(), this.locale));
        res.put("category", HtmlUtils.htmlEscape((String)this.internationalizationHelper.getMessage(item.getCategory().getLabel(), null, item.getCategory().getLabel(), this.locale)));
        res.put("status", this.internationalizationHelper.internationalize((Internationalizable)item.getStatus(), this.locale));
        res.put("milestone-dates", MilestoneModelUtils.timeIntervalToString(item.getMilestones(), this.internationalizationHelper, this.locale));
        res.put("empty-delete-holder", " ");
        res.put("milestone", MilestoneModelUtils.milestoneLabelsOrderByDate(item.getMilestones()));
        res.put("short-description", HTMLCleanupUtils.getCleanedBriefText(item.getDescription(), 50));
        res.put("description", HtmlUtils.htmlEscape((String)item.getDescription()));
        res.put("category-icon", HtmlUtils.htmlEscape((String)item.getCategory().getIconName()));
        res.put("criticality-level", item.getCriticality().getLevel());
        res.put("status-level", item.getStatus().getLevel());
        res.put("readable", this.permService.canRead((Object)item.getVerifiedRequirementVersion()));
        return res;
    }

    static class TestCaseVerifiedRequirementsDataTableModelHelper
    extends VerifiedRequirementsDataTableModelHelper {
        TestCaseVerifiedRequirementsDataTableModelHelper(Locale locale, InternationalizationHelper internationalizationHelper, PermissionEvaluationService permService) {
            super(locale, internationalizationHelper, permService);
        }

        @Override
        public Map<String, Object> buildItemData(VerifiedRequirement item) {
            Map<String, Object> res = super.buildItemData(item);
            res.put("verifyingSteps", this.getVerifyingSteps(item));
            return res;
        }

        private String getVerifyingSteps(VerifiedRequirement item) {
            String result = "";
            Set steps = item.getVerifyingSteps();
            if (!steps.isEmpty()) {
                if (steps.size() == 1) {
                    ActionTestStep step = (ActionTestStep)steps.iterator().next();
                    result = "<span class='verifyingStep' dataId='" + step.getId() + "'>" + (step.getIndex() + 1) + "</span>";
                } else {
                    result = "&#42;";
                }
            }
            return result;
        }
    }

    static final class TestCaseWithCalledStepsVerifiedRequirementsDataTableModelHelper
    extends TestCaseVerifiedRequirementsDataTableModelHelper {
        TestCaseWithCalledStepsVerifiedRequirementsDataTableModelHelper(Locale locale, InternationalizationHelper internationalizationHelper, PermissionEvaluationService permService) {
            super(locale, internationalizationHelper, permService);
        }

        @Override
        public Map<String, Object> buildItemData(VerifiedRequirement item) {
            Map<String, Object> resMap = super.buildItemData(item);
            resMap.put("directlyVerified", item.isDirectVerification());
            return resMap;
        }
    }

    static final class TestStepVerifiedRequirementsDataTableModelHelper
    extends VerifiedRequirementsDataTableModelHelper {
        private long stepId;
        private TestCase testCase;

        TestStepVerifiedRequirementsDataTableModelHelper(Locale locale, InternationalizationHelper internationalizationHelper, PermissionEvaluationService permService, long stepId, TestCase testCase) {
            super(locale, internationalizationHelper, permService);
            this.stepId = stepId;
            this.testCase = testCase;
        }

        @Override
        public Map<String, Object> buildItemData(VerifiedRequirement item) {
            Map<String, Object> res = super.buildItemData(item);
            item.withVerifyingStepsFrom(this.testCase);
            res.put("verifiedByStep", item.hasStepAsVerifying(this.stepId));
            res.put("empty-link-checkbox", "");
            return res;
        }
    }
}

