/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.requirement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

public class RequirementVerifierView {
    private TestCase verifier;
    private ActionTestStep verifyingStep;
    private String type;
    private InternationalizationHelper internationalizationHelper;
    private Locale locale;

    public RequirementVerifierView(TestCase requirementVerifier) {
        this.verifier = requirementVerifier;
        this.type = "test-cases";
    }

    public RequirementVerifierView(ActionTestStep verifyingStep) {
        this.verifier = verifyingStep.getTestCase();
        this.verifyingStep = verifyingStep;
        this.type = "test-step";
    }

    public RequirementVerifierView(ActionTestStep verifyingStep, InternationalizationHelper internationalizationHelper, Locale locale) {
        this.verifier = verifyingStep.getTestCase();
        this.verifyingStep = verifyingStep;
        this.internationalizationHelper = internationalizationHelper;
        this.locale = locale;
        this.type = "test-step";
    }

    public TestCase getVerifier() {
        return this.verifier;
    }

    public void setVerifier(TestCase verifier) {
        this.verifier = verifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ActionTestStep getVerifyingStep() {
        return this.verifyingStep;
    }

    public void setVerifyingStep(ActionTestStep verifyingStep) {
        this.verifyingStep = verifyingStep;
    }

    public List<RequirementVersionCoverageView> getCoverages() {
        ArrayList<RequirementVersionCoverageView> coverages = new ArrayList<RequirementVersionCoverageView>(0);
        for (RequirementVersionCoverage rc : this.verifier.getRequirementVersionCoverages()) {
            RequirementVersionCoverageView coverage = new RequirementVersionCoverageView(rc, this.verifyingStep);
            coverage.calculateMilestoneTimeInterval(this.internationalizationHelper, this.locale);
            coverages.add(coverage);
        }
        Collections.sort(coverages, new Comparator<RequirementVersionCoverageView>(){

            @Override
            public int compare(RequirementVersionCoverageView view1, RequirementVersionCoverageView view2) {
                return view1.version.getName().compareToIgnoreCase(view2.version.getName());
            }
        });
        return coverages;
    }

    public static final class RequirementVersionCoverageView {
        private RequirementVersion version;
        private String milestoneTimeInterval;
        private boolean verifiedByStep = false;

        public RequirementVersionCoverageView(RequirementVersionCoverage rc, ActionTestStep step) {
            this.version = rc.getVerifiedRequirementVersion();
            if (step != null) {
                for (ActionTestStep verifyingStep : rc.getVerifyingSteps()) {
                    if (!step.getId().equals(verifyingStep.getId())) continue;
                    this.verifiedByStep = true;
                    break;
                }
            }
        }

        public void calculateMilestoneTimeInterval(InternationalizationHelper internationalizationHelper, Locale locale) {
            this.milestoneTimeInterval = MilestoneModelUtils.timeIntervalToString(this.version.getMilestones(), internationalizationHelper, locale);
        }

        public RequirementVersion getVersion() {
            return this.version;
        }

        public boolean isVerifiedByStep() {
            return this.verifiedByStep;
        }

        public String getMilestoneTimeInterval() {
            return this.milestoneTimeInterval;
        }

        public void setMilestoneTimeInterval(String milestoneTimeInterval) {
            this.milestoneTimeInterval = milestoneTimeInterval;
        }
    }
}

