/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.parameters;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.testcase.IsKeywordTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.parameters.DatasetsTableColumnDefHelper;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParameterNameComparator;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParametersModelHelper;
import org.squashtest.tm.web.internal.controller.testcase.parameters.SimpleParameter;
import org.squashtest.tm.web.internal.controller.widget.AoColumnDef;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@RequestMapping(value={"/test-cases/{testCaseId}/parameters"})
@Controller
public class TestCaseParametersController {
    @Inject
    private TestCaseFinder testCaseFinder;
    @Inject
    private ParameterModificationService parameterModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    private DatatableMapper<String> parametersTableMapper = new NameBasedMapper(3).mapAttribute("name", "name", Parameter.class).mapAttribute("test-case-name", "name", TestCase.class);
    private static final String TEST_CASE = "testCase";

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SimpleParameter> getParameters(@PathVariable(value="testCaseId") long testCaseId, Locale locale) {
        List parameters = this.parameterModificationService.findAllParameters(testCaseId);
        return SimpleParameter.convertToSimpleParameters(parameters, testCaseId, this.messageSource, locale);
    }

    @RequestMapping(value={"/panel"}, method={RequestMethod.GET})
    public String getParametersPanel(@PathVariable(value="testCaseId") long testCaseId, Model model, Locale locale) {
        TestCase testCase = this.testCaseFinder.findById(testCaseId);
        List directAndCalledParameters = this.parameterModificationService.findAllParameters(testCaseId);
        Collections.sort(directAndCalledParameters, new ParameterNameComparator(SortOrder.ASCENDING));
        List paramIds = IdentifiedUtil.extractIds((Collection)directAndCalledParameters);
        boolean editable = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)testCase);
        List<AoColumnDef> columnDefs = new DatasetsTableColumnDefHelper().getAoColumnDefs(paramIds, editable);
        List<HashMap<String, String>> paramHeaders = ParametersModelHelper.findDatasetParamHeaders(testCaseId, locale, directAndCalledParameters, this.messageSource);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testCase);
        model.addAttribute(TEST_CASE, (Object)testCase);
        model.addAttribute("datasetsAoColumnDefs", (Object)JsonHelper.serialize(columnDefs));
        model.addAttribute("paramHeaders", paramHeaders);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        IsKeywordTestCaseVisitor isKeywordTestCaseVisitor = new IsKeywordTestCaseVisitor();
        testCase.accept((TestCaseVisitor)isKeywordTestCaseVisitor);
        model.addAttribute("isKeywordTestCase", (Object)isKeywordTestCaseVisitor.isKeyword());
        return "test-cases-tabs/parameters-tab.html";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getParametersTable(@PathVariable long testCaseId, DataTableDrawParameters params, Locale locale) {
        List parameters = this.parameterModificationService.findAllParameters(testCaseId);
        DataTableSorting sorting = new DataTableSorting(params, this.parametersTableMapper);
        this.sortParams((Sorting)sorting, parameters, testCaseId);
        SinglePageCollectionHolder holder = new SinglePageCollectionHolder((Collection)parameters);
        return new ParametersModelHelper(testCaseId, this.messageSource, locale).buildDataModel(holder, params.getsEcho());
    }

    private void sortParams(Sorting sorting, List<Parameter> parameters, Long testCaseId) {
        String sortedAttribute = sorting.getSortedAttribute();
        SortOrder sortOrder = sorting.getSortOrder();
        if (sortedAttribute != null && "Parameter.name".equals(sortedAttribute)) {
            Collections.sort(parameters, new ParameterNameComparator(sortOrder));
        } else if (sortedAttribute != null && "TestCase.name".equals(sortedAttribute)) {
            Collections.sort(parameters, new ParameterTestCaseNameComparator(sortOrder, testCaseId));
        } else {
            Collections.sort(parameters, new ParameterNameComparator(SortOrder.ASCENDING));
        }
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void newParameter(@PathVariable long testCaseId, @Valid @ModelAttribute(value="add-parameter") Parameter parameter) {
        try {
            this.parameterModificationService.addNewParameterToTestCase(parameter, testCaseId);
        }
        catch (DomainException e) {
            e.setObjectName("add-parameter");
            throw e;
        }
    }

    private static final class ParameterTestCaseNameComparator
    implements Comparator<Parameter>,
    Serializable {
        private SortOrder sortOrder;
        private Long testCaseId;

        private ParameterTestCaseNameComparator(SortOrder sortOrder, Long testCaseId) {
            this.sortOrder = sortOrder;
            this.testCaseId = testCaseId;
        }

        @Override
        public int compare(Parameter o1, Parameter o2) {
            boolean o1DirectParam = this.testCaseId.equals(o1.getTestCase().getId());
            boolean o2DirectParam = this.testCaseId.equals(o2.getTestCase().getId());
            int ascResult = ParametersModelHelper.buildTestCaseName(o1, o1DirectParam).compareTo(ParametersModelHelper.buildTestCaseName(o2, o2DirectParam));
            if (this.sortOrder == SortOrder.ASCENDING) {
                return ascResult;
            }
            return -ascResult;
        }
    }
}

