/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.parameters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.web.internal.controller.testcase.parameters.DatasetsTableColumnDefHelper;
import org.squashtest.tm.web.internal.controller.testcase.parameters.NewDataset;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParameterNameComparator;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParametersModelHelper;
import org.squashtest.tm.web.internal.controller.widget.AoColumnDef;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.json.JsonDataset;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@RequestMapping(value={"/test-cases/{testCaseId}/datasets"})
@Controller
public class TestCaseDatasetsController {
    @Inject
    private TestCaseFinder testCaseFinder;
    @Inject
    private DatasetModificationService datasetModificationService;
    @Inject
    private ParameterFinder parameterFinder;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private MessageSource messageSource;
    private DatatableMapper<String> datasetsTableMapper = new NameBasedMapper(3).mapAttribute("entity-id", "id", Dataset.class).mapAttribute("name", "name", Dataset.class);

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Collection<JsonDataset> getAvailableDatasets(@PathVariable(value="testCaseId") long testCaseId) {
        Collection datasets = this.datasetModificationService.findAllForTestCase(testCaseId);
        ArrayList<JsonDataset> result = new ArrayList<JsonDataset>(datasets.size());
        for (Dataset ds : datasets) {
            JsonDataset jds = new JsonDataset();
            jds.setId(ds.getId());
            jds.setName(HtmlUtils.htmlEscape((String)ds.getName()));
            result.add(jds);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getDatasetsTableDatas(@PathVariable long testCaseId, DataTableDrawParameters params) {
        List<Dataset> datasetsList = this.getSortedDatasets(testCaseId, params);
        SinglePageCollectionHolder holder = new SinglePageCollectionHolder(datasetsList);
        return new DatasetsDataTableModelHelper().buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/table/aoColumnDef"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AoColumnDef> getDatasetsTableColumnDefs(@PathVariable long testCaseId) {
        TestCase testCase = this.testCaseFinder.findById(testCaseId);
        List<Parameter> directAndCalledParameters = this.getSortedDirectAndCalledParameters(testCaseId);
        List paramIds = IdentifiedUtil.extractIds(directAndCalledParameters);
        boolean editable = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)testCase);
        return new DatasetsTableColumnDefHelper().getAoColumnDefs(paramIds, editable);
    }

    @RequestMapping(value={"/table/param-headers"}, method={RequestMethod.GET})
    @ResponseBody
    public List<HashMap<String, String>> getDatasetsTableParametersHeaders(@PathVariable long testCaseId, Locale locale) {
        List<Parameter> directAndCalledParameters = this.getSortedDirectAndCalledParameters(testCaseId);
        return ParametersModelHelper.findDatasetParamHeaders(testCaseId, locale, directAndCalledParameters, this.messageSource);
    }

    private List<Parameter> getSortedDirectAndCalledParameters(long testCaseId) {
        List directAndCalledParameters = this.parameterFinder.findAllParameters(testCaseId);
        Collections.sort(directAndCalledParameters, new ParameterNameComparator(SortOrder.ASCENDING));
        return directAndCalledParameters;
    }

    public static Map<String, String> findDatasetParamHeadersByParamId(long testCaseId, Locale locale, List<Parameter> directAndCalledParameters, MessageSource messageSource) {
        HashMap<String, String> result = new HashMap<String, String>(directAndCalledParameters.size());
        for (Parameter param : directAndCalledParameters) {
            result.put(param.getId().toString(), HtmlUtils.htmlEscape((String)ParametersModelHelper.buildParameterName(param, testCaseId, messageSource, locale)));
        }
        return result;
    }

    private List<Dataset> getSortedDatasets(long testCaseId, DataTableDrawParameters params) {
        TestCase testCase = this.testCaseFinder.findById(testCaseId);
        DataTableSorting sorting = new DataTableSorting(params, this.datasetsTableMapper);
        Set datasets = testCase.getDatasets();
        ArrayList<Dataset> datasetsList = new ArrayList<Dataset>(datasets);
        if (sorting.getSortedAttribute() != null && ("Parameter.name".equals(sorting.getSortedAttribute()) || "Dataset.name".equals(sorting.getSortedAttribute()))) {
            Collections.sort(datasetsList, new DatasetNameComparator(sorting.getSortOrder()));
        } else {
            Collections.sort(datasetsList, new DatasetNameComparator(SortOrder.ASCENDING));
        }
        return datasetsList;
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void newDataset(@PathVariable long testCaseId, @Valid @RequestBody NewDataset dataset) {
        try {
            this.datasetModificationService.persist(dataset.createTransientEntity(this.parameterFinder), testCaseId);
        }
        catch (DomainException e) {
            e.setObjectName("add-dataset");
            throw e;
        }
    }

    private static final class DatasetNameComparator
    implements Comparator<Dataset>,
    Serializable {
        private SortOrder sortOrder;

        private DatasetNameComparator(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public int compare(Dataset o1, Dataset o2) {
            int ascResult = o1.getName().compareTo(o2.getName());
            if (this.sortOrder == SortOrder.ASCENDING) {
                return ascResult;
            }
            return -ascResult;
        }
    }

    public static final class DatasetsDataTableModelHelper
    extends DataTableModelBuilder<Dataset> {
        public Map<String, Object> buildItemData(Dataset item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("entity-id", item.getId());
            res.put("entity-index", this.getCurrentIndex());
            res.put("name", HtmlUtils.htmlEscape((String)item.getName()));
            for (DatasetParamValue parameterValue : item.getParameterValues()) {
                res.put("parameter-" + parameterValue.getParameter().getId(), "id=" + parameterValue.getId() + ", value=" + HTMLCleanupUtils.cleanAndUnescapeHTML(parameterValue.getParamValue()));
            }
            res.put("empty-delete-holder", "");
            return res;
        }
    }
}

