/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.parameters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParametersModelHelper;

public class SimpleParameter {
    private long id;
    private String name = "";
    private long testCaseId;

    public SimpleParameter(long id, String name, long testCaseId) {
        this.id = id;
        this.name = name;
        this.testCaseId = testCaseId;
    }

    public SimpleParameter(Parameter parameter) {
        this(parameter.getId(), parameter.getName(), parameter.getTestCase().getId());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public static List<SimpleParameter> convertToSimpleParameters(List<Parameter> parameters, Long ownerId2, MessageSource messageSource2, Locale locale2) {
        ArrayList<SimpleParameter> result = new ArrayList<SimpleParameter>(parameters.size());
        for (Parameter param : parameters) {
            String newName = HtmlUtils.htmlEscape((String)ParametersModelHelper.buildParameterName(param, ownerId2, messageSource2, locale2));
            SimpleParameter simpleParameter = new SimpleParameter(param);
            simpleParameter.setName(newName);
            result.add(simpleParameter);
        }
        return result;
    }
}

