/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParameterNameComparator;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public final class ParametersModelHelper
extends DataTableModelBuilder<Parameter> {
    private long ownerId;
    private MessageSource messageSource;
    private Locale locale;

    public ParametersModelHelper(long ownerId, MessageSource messageSource, Locale locale) {
        this.ownerId = ownerId;
        this.messageSource = messageSource;
        this.locale = locale;
    }

    public Map<String, Object> buildItemData(Parameter item) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Long tcId = item.getTestCase().getId();
        boolean isDirectParam = Long.valueOf(this.ownerId).equals(tcId);
        String testCaseName = ParametersModelHelper.buildTestCaseName(item, isDirectParam);
        res.put("entity-id", item.getId());
        res.put("entity-index", this.getCurrentIndex());
        res.put("name", HtmlUtils.htmlEscape((String)ParametersModelHelper.buildParameterName(item, this.ownerId, this.messageSource, this.locale)));
        res.put("description", HTMLCleanupUtils.cleanHtml(item.getDescription()));
        res.put("test-case-name", testCaseName);
        res.put("tc-id", tcId);
        res.put("directly-associated", isDirectParam);
        res.put("empty-delete-holder", "");
        return res;
    }

    public static String buildParameterName(Parameter item, Long ownerId2, MessageSource messageSource2, Locale locale2) {
        String tcSmall = messageSource2.getMessage("label.testCases.short", null, locale2);
        TestCase paramTC = item.getTestCase();
        if (!ownerId2.equals(paramTC.getId())) {
            return String.valueOf(item.getName()) + " (" + tcSmall + "_" + paramTC.getId() + ")";
        }
        return item.getName();
    }

    public static String buildTestCaseName(Parameter item, boolean isDirectParam) {
        if (isDirectParam) {
            return "";
        }
        TestCase testCase = item.getTestCase();
        Project project = testCase.getProject();
        String testCaseName = String.valueOf(testCase.getName()) + " (" + project.getName() + ')';
        if (!testCase.getReference().isEmpty()) {
            testCaseName = String.valueOf(testCase.getReference()) + '-' + testCaseName;
        }
        return HtmlUtils.htmlEscape((String)testCaseName);
    }

    public static List<HashMap<String, String>> findDatasetParamHeaders(long testCaseId, Locale locale, List<Parameter> directAndCalledParameters, MessageSource messageSource) {
        Collections.sort(directAndCalledParameters, new ParameterNameComparator(SortOrder.ASCENDING));
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>(directAndCalledParameters.size());
        for (Parameter param : directAndCalledParameters) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ParametersModelHelper.buildParameterName(param, testCaseId, messageSource, locale));
            map.put("description", HTMLCleanupUtils.htmlToText(param.getDescription()));
            map.put("id", param.getId().toString());
            result.add(map);
        }
        return result;
    }
}

