/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.parameters;

import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@RequestMapping(value={"/parameters"})
@Controller
public class ParameterController {
    private static final String PARAMETER_ID_URL = "/{parameterId}";
    @Inject
    private ParameterModificationService parameterModificationService;

    @RequestMapping(value={"/{parameterId}/used"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isUsedParameter(@PathVariable long parameterId) {
        return this.parameterModificationService.isUsed(parameterId);
    }

    @RequestMapping(value={"/{parameterId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteParameter(@PathVariable long parameterId) {
        this.parameterModificationService.removeById(parameterId);
    }

    @RequestMapping(value={"/{parameterId}/name"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeName(@PathVariable long parameterId, @RequestParam(value="value") String value) {
        this.parameterModificationService.changeName(parameterId, value);
        return HtmlUtils.htmlEscape((String)value);
    }

    @RequestMapping(value={"/{parameterId}/description"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeDescription(@PathVariable long parameterId, @RequestParam(value="value") String value) {
        this.parameterModificationService.changeDescription(parameterId, value);
        return HTMLCleanupUtils.cleanHtml(value);
    }

    @RequestMapping(value={"/validate"}, method={RequestMethod.POST}, params={"value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public void validateActionStep(@RequestParam(value="value") String newAction) {
        Parameter.findUsedParameterNamesInString((String)newAction);
    }
}

